% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFO.oc.R
\name{CFO.oc}
\alias{CFO.oc}
\title{Generate operating characteristics of sigle-drug trials in multiple simulations}
\usage{
CFO.oc(nsimu = 5000, design, target, p.true, init.level = 1, ncohort, cohortsize,
       assess.window = NA, tte.para = NA, accrual.rate = NA, accrual.dist = NA, 
       prior.para = list(alp.prior = target, bet.prior = 1 - target),
       cutoff.eli = 0.95, early.stop = 0.95, seeds = NULL)
}
\arguments{
\item{nsimu}{the total number of trials to be simulated. The default value is 5000.}

\item{design}{option for selecting different designs, which can be set as \code{'CFO'}, \code{'aCFO'},
\code{'TITE-CFO'}, \code{'TITE-aCFO'}, \code{'fCFO'}, \code{'f-aCFO'}, \code{'bCFO'},
and \code{'b-aCFO'}. Specifically, \code{'bCFO'} refers to the benchmark CFO design, and
\code{'b-aCFO'} denotes the benchmark aCFO design.}

\item{target}{the target DLT rate.}

\item{p.true}{the true DLT rates under the different dose levels.}

\item{init.level}{the dose level assigned to the first cohort. The default value \code{init.level} is 1.}

\item{ncohort}{the total number of cohorts.}

\item{cohortsize}{the number of patients of each cohort.}

\item{assess.window}{the maximal assessment window size. \code{NA} should be assigned if the design without late-oneset outcomes.}

\item{tte.para}{the parameter related with the distribution of the time to DLT events. The time to DLT is sampled from a Weibull
distribution, with \code{tte.para} representing the proportion of DLTs occurring within the first half of the
assessment window. \code{NA} should be assigned if the design without late-oneset outcomes.}

\item{accrual.rate}{the accrual rate, i.e., the number of patients accrued per unit time. \code{NA} should be assigned
if the design without late-onset outcomes.}

\item{accrual.dist}{the distribution of the arrival times of patients. When \code{accrual.dist = 'fix'}, it corresponds to all
patients in each cohort arriving simultaneously at a given accrual rate. When \code{accrual.dist = 'unif'},
it corresponds to a uniform distribution, and when \code{accrual.dist = 'exp'}, it corresponds to an
exponential distribution. \code{NA} should be assigned if the design without late-oneset outcomes.}

\item{prior.para}{the prior parameters for a beta distribution, where set as \code{list(alp.prior = target, bet.prior = 1 - target)}
by default, \code{alp.prior} and \code{bet.prior} represent the parameters of the prior distribution for
the true DLT rate at any dose level. This prior distribution is specified as Beta(\code{alpha.prior}, \code{beta.prior}).}

\item{cutoff.eli}{the cutoff to eliminate overly toxic doses for safety. We recommend
the default value of \code{cutoff.eli = 0.95} for general use.}

\item{early.stop}{the threshold value for early stopping. The default value \code{early.stop = 0.95}
generally works well.}

\item{seeds}{A vector of random seeds for each simulation, for example, \code{seeds = 1:nsimu} (default is NULL).}
}
\value{
The \code{CFO.oc()} function returns basic setup of ($simu.setup) and the operating
characteristics of the design: \cr
\itemize{
\item p.true: the true DLT rates under the different dose levels.
\item selpercent: the selection percentage at each dose level.
\item npatients: the averaged number of patients treated at each dose level in one simulation.
\item ntox: the averaged number of toxicity observed at each dose level in one simulation.
\item MTDsel: the percentage of correct selection of the MTD.
\item MTDallo: the percentage of patients allocated to the MTD.
\item oversel: the percentage of selecting a dose above the MTD.
\item overallo: the percentage of allocating patients at dose levels above the MTD.
\item averDLT: the percentage of the patients suffering DLT.
\item averdur: the average trial duration if trials with late-onset toxicities.
\item percentstop: the percentage of early stopping without selecting the MTD.
\item simu.setup: the parameters for the simulation set-up.
}
}
\description{
This function is used to perform multiple simulations for single-drug trials and obtain relevant operating characteristics.
}
\note{
The operating characteristics are generated by simulating multiple single-drug trials under the
pre-specified true toxicity probabilities of the investigational doses. The choice of which design to execute
is determined by setting the \code{design} argument. Some time-related arguments (\code{assess.window}, \code{accrual.rate},
\code{tte.para}, and \code{accrual.dist}) need to be set as values only when running a design that can handle late-onset
toxicities; otherwise, they default to \code{NA}.\cr
Additionally, in the example, we set \code{nsimu = 5} for testing time considerations. In reality, \code{nsimu}
is typically set to 5000 to ensure the accuracy of the results.
}
\examples{
## setting
nsimu <- 5; target <- 0.2; ncohort <- 10; cohortsize <- 3; init.level <- 1
p.true <- c(0.01, 0.07, 0.20, 0.35, 0.50, 0.65, 0.80)
prior.para = list(alp.prior = target, bet.prior = 1 - target)
assess.window <- 3; accrual.rate <- 2; tte.para <- 0.5; accrual.dist <- 'unif'


## get the operating characteristics for 5 simulations using the f-aCFO design
faCFOoc <- CFO.oc (nsimu, design='f-aCFO', target, p.true, init.level, ncohort, cohortsize,
        assess.window, tte.para, accrual.rate, accrual.dist, seeds = 1:nsimu)
summary(faCFOoc)
plot(faCFOoc)

\donttest{
# This test may take longer than 5 seconds to run
# It is provided for illustration purposes only
# Users can run this code directly

## get the operating characteristics for 5 simulations using the CFO design
CFOoc <- CFO.oc (nsimu, design = 'CFO', target, p.true, init.level, ncohort, cohortsize,
         assess.window = NA, tte.para = NA, accrual.rate = NA, accrual.dist = NA, seeds = 1:nsimu)
summary(CFOoc)
plot(CFOoc)

## get the operating characteristics for 5 simulations using the aCFO design
aCFOoc <- CFO.oc (nsimu, design = 'aCFO', target, p.true, init.level, ncohort, cohortsize,
       assess.window = NA, tte.para = NA, accrual.rate = NA, accrual.dist = NA, seeds = 1:nsimu)
summary(aCFOoc)
plot(aCFOoc)
## get the operating characteristics for 5 simulations using the TITE-CFO design
TITECFOoc <- CFO.oc (nsimu, design = 'TITE-CFO', target, p.true, init.level, ncohort, cohortsize,
        assess.window, tte.para, accrual.rate, accrual.dist, seeds = 1:nsimu)
summary(TITECFOoc)
plot(TITECFOoc)
## get the operating characteristics for 5 simulations using the TITE-aCFO design
TITEaCFOoc <- CFO.oc (nsimu, design = 'TITE-aCFO', target, p.true, init.level, ncohort, cohortsize,
        assess.window, tte.para, accrual.rate, accrual.dist, seeds = 1:nsimu)
summary(TITEaCFOoc)
plot(TITEaCFOoc)
## get the operating characteristics for 5 simulations using the fCFO design
fCFOoc <- CFO.oc (nsimu, design = 'fCFO', target, p.true, init.level, ncohort, cohortsize,
        assess.window, tte.para, accrual.rate, accrual.dist, seeds = 1:nsimu)
summary(fCFOoc)
plot(fCFOoc)
## get the operating characteristics for 5 simulations using the bCFO design
bCFOoc <- CFO.oc (nsimu, design = 'bCFO', target, p.true, init.level, ncohort, cohortsize,
        assess.window, tte.para, accrual.rate, accrual.dist, seeds = 1:nsimu)
summary(bCFOoc)
plot(bCFOoc)
## get the operating characteristics for 5 simulations using the b-aCFO design
baCFOoc <- CFO.oc (nsimu, design = 'b-aCFO', target, p.true, init.level, ncohort, cohortsize,
        assess.window, tte.para, accrual.rate, accrual.dist, seeds = 1:nsimu)
summary(baCFOoc)
plot(baCFOoc)
}
}
\references{
Jin H, Yin G (2022). CFO: Calibration-free odds design for phase I/II clinical trials.
\emph{Statistical Methods in Medical Research}, 31(6), 1051-1066. \cr
Jin H, Yin G (2023). Time‐to‐event calibration‐free odds design: A robust efficient design for
phase I trials with late‐onset outcomes. \emph{Pharmaceutical Statistics}. 22(5), 773–783.\cr
Yin G, Zheng S, Xu J (2013). Fractional dose-finding methods with late-onset toxicity in
phase I clinical trials. \emph{Journal of Biopharmaceutical Statistics}, 23(4), 856-870.\cr
Fang J, Yin G (2024). Fractional accumulative calibration‐free odds (f‐aCFO) design for delayed toxicity
in phase I clinical trials. \emph{Statistics in Medicine}.
}
\author{
Jialu Fang, Wenliang Wang, and Guosheng Yin
}
