% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFOeff.oc.R
\name{CFOeff.oc}
\alias{CFOeff.oc}
\title{Generate operating characteristics of phase I/II trials single-drug trials in multiple simulations.}
\usage{
CFOeff.oc(target, p.true=p.true, pE.true=pE.true, prior.para = 
                 list(alp.prior = target, bet.prior = 1 - target, 
                 alp.prior.eff = 0.5, bet.prior.eff = 0.5),  
                 init.level = 1, cohortsize=cohortsize, ncohort=ncohort, 
                 nsimu, cutoff.eli=0.95, 
                 early.stop=0.95, effearly.stop = 0.9, mineff,
                 seeds = NULL)
}
\arguments{
\item{target}{the target DLT rate.}

\item{p.true}{the true DLT rates under the different dose levels.}

\item{pE.true}{the true efficacy rates under the different dose levels.}

\item{prior.para}{the prior parameters for two beta distributions, where set as \code{list(alp.prior = target, 
                 bet.prior = 1 - target, alp.prior.eff = 0.5, bet.prior.eff = 0.5)} by default. \code{alp.prior} and \code{bet.prior}
represent the parameters of the prior distribution for the true DLT rate at any dose level. This prior distribution
is specified as Beta(\code{alpha.prior}, \code{beta.prior}). \code{alp.eff.prior} and \code{bet.eff.prior}
represent the parameters of the Jeffreys' prior distribution for the efficacy probability at any dose level.
This prior distribution is specified as Beta(\code{alpha.eff.prior}, \code{beta.eff.prior}).}

\item{init.level}{the dose level assigned to the first cohort. The default value \code{init.level} is 1.}

\item{cohortsize}{the number of patients in each cohort.}

\item{ncohort}{the total number of cohorts.}

\item{nsimu}{the total number of trials to be simulated.}

\item{cutoff.eli}{the cutoff to eliminate overly toxic doses for safety. We recommend
the default value of \code{cutoff.eli = 0.95} for general use.}

\item{early.stop}{the threshold value for early stopping due to overly toxic. The default value \code{early.stop = 0.95}
generally works well.}

\item{effearly.stop}{the threshold value for early stopping due to low efficacy. The trial would be terminated
early if \eqn{Pr(q_k<\psi |y_k,m_k \ge 3)} is smaller than the value of \code{effearly.stop} where \eqn{q_k, y_k} and \eqn{m_k}
are the efficacy probability, the number of efficacy outcomes and the number of patients at dose level \eqn{k}.
\eqn{\psi} is the the lowest acceptable efficacy rate which is set by \code{mineff} here.
By default, \code{effearly.stop} is set as \code{0.9}.}

\item{mineff}{the lowest acceptable efficacy rate.}

\item{seeds}{a vector of random seeds for each simulation, for example, \code{seeds = 1:nsimu} (default is \code{NULL}).}
}
\value{
The \code{CFOeff.oc()} function returns a list object, which includes the basic setup (\code{simu.setup}), comprising the following components:
\itemize{
\item p.true: the true DLT rates under the different dose levels.
\item pE.true: the true efficacy rates under the different dose levels.
\item selpercent: the selection percentage at each dose level.
\item npatients: the averaged number of patients treated at each dose level in one simulation.
\item ntox: the averaged number of toxicity observed at each dose level in one simulation.
\item neff: the averaged number of efficacy outcome at each dose level in one simulation.
\item OBDsel: the percentage of correct selection of the OBD.
\item OBDallo: the percentage of patients allocated to the OBD.
\item averDLT: the percentage of the patients suffering DLT.
\item avereff: the percentage of the patients with efficacy outcomes.
\item percentstop: the percentage of early stopping without selecting the OBD.
\item simu.setup: the parameters for the simulation set-up.
\item class: the phase of the trial.
}
}
\description{
Based on the toxicity outcomes and efficacy outcomes, this function is used to perform multiple simulations for phase I/II single-drug trials and obtain relevant operating characteristics.
}
\note{
In the example, we set \code{nsimu = 3} for testing time considerations.
In reality, \code{nsimu} is typically set as 5000 to ensure the accuracy of the results.
}
\examples{
target <- 0.30; mineff <- 0.30; cohortsize = 3; ncohort = 12; nsimu = 3; init.level = 1
prior.para = list(alp.prior = target, bet.prior = 1 - target, 
                  alp.prior.eff = 0.5, bet.prior.eff = 0.5)
p.true=c(0.05, 0.07, 0.1, 0.12, 0.16)
pE.true=c(0.35, 0.45, 0.5, 0.55, 0.75)
result <- CFOeff.oc (target, p.true, pE.true, prior.para, 
          init.level,cohortsize, ncohort, nsimu, mineff = mineff, seeds = 1:nsimu)
summary(result)
plot(result)
\donttest{#earlystop for overly tox
target <- 0.30; mineff <- 0.30; cohortsize = 3; ncohort = 12; nsimu = 3; init.level = 1
prior.para = list(alp.prior = target, bet.prior = 1 - target, 
                  alp.prior.eff = 0.5, bet.prior.eff = 0.5)
p.true=c(0.75, 0.77, 0.81, 0.82, 0.86)
pE.true=c(0.35, 0.45, 0.5, 0.55, 0.75)
result <- CFOeff.oc (target, p.true, pE.true, prior.para, 
          init.level,cohortsize, ncohort, nsimu, mineff = mineff, seeds = 1:nsimu)
summary(result)
plot(result)
}
\donttest{#earlystop for lower efficacy
target <- 0.30; mineff <- 0.30; cohortsize = 3; ncohort = 20; nsimu = 3; init.level = 1
prior.para = list(alp.prior = target, bet.prior = 1 - target, 
                  alp.prior.eff = 0.5, bet.prior.eff = 0.5)
p.true=c(0.05, 0.07, 0.1, 0.12, 0.16)
pE.true=c(0.001, 0.001, 0.001, 0.002, 0.003)
result <- CFOeff.oc (target, p.true, pE.true, prior.para, 
          init.level,cohortsize, ncohort, nsimu, mineff = mineff, seeds = 1:nsimu)
summary(result)
plot(result)
}
}
\references{
Jin H, Yin G (2022). CFO: Calibration-free odds design for phase I/II clinical trials.
\emph{Statistical Methods in Medical Research}, 31(6), 1051-1066. \cr
}
\author{
Jialu Fang, Ninghao Zhang, Wenliang Wang, and Guosheng Yin
}
