% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFtime.R
\name{==,CFtime,CFtime-method}
\alias{==,CFtime,CFtime-method}
\title{Equivalence of CFtime objects}
\usage{
\S4method{==}{CFtime,CFtime}(e1, e2)
}
\arguments{
\item{e1, e2}{CFts. Instances of the \code{CFtime} class.}
}
\value{
\code{TRUE} if the \code{CFtime} objects are equivalent, \code{FALSE} otherwise.
}
\description{
This operator can be used to test if two \code{CFtime} objects represent the same
CF-convention time coordinates. Two \code{CFtime} objects are considered equivalent
if they have an equivalent datum and the same offsets.
}
\examples{
e1 <- CFtime("days since 1850-01-01", "gregorian", 0:364)
e2 <- CFtime("days since 1850-01-01 00:00:00", "standard", 0:364)
e1 == e2
}
