% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_plot.R
\name{CGGPvalstats}
\alias{CGGPvalstats}
\title{Calculate stats for CGGP prediction on validation data}
\usage{
CGGPvalstats(CGGP, Xval, Yval, bydim = TRUE, ...)
}
\arguments{
\item{CGGP}{CGGP object}

\item{Xval}{X validation matrix}

\item{Yval}{Y validation data}

\item{bydim}{If multiple outputs, should it be done separately by dimension?}

\item{...}{Passed to valstats, such as which stats to calculate.}
}
\value{
data frame
}
\description{
Calculate stats for CGGP prediction on validation data
}
\examples{
\donttest{
SG <- CGGPcreate(d=3, batchsize=100)
f1 <- function(x){x[1]+x[2]^2}
y <- apply(SG$design, 1, f1)
SG <- CGGPfit(SG, y)
Xval <- matrix(runif(3*100), ncol=3)
Yval <- apply(Xval, 1, f1)
CGGPvalstats(CGGP=SG, Xval=Xval, Yval=Yval)

# Multiple outputs
SG <- CGGPcreate(d=3, batchsize=100)
f1 <- function(x){x[1]+x[2]^2}
f2 <- function(x){x[1]^1.3+.4*sin(6*x[2])+10}
y1 <- apply(SG$design, 1, f1)#+rnorm(1,0,.01)
y2 <- apply(SG$design, 1, f2)#+rnorm(1,0,.01)
y <- cbind(y1, y2)
SG <- CGGPfit(SG, Y=y)
Xval <- matrix(runif(3*100), ncol=3)
Yval <- cbind(apply(Xval, 1, f1),
              apply(Xval, 1, f2))
CGGPvalstats(SG, Xval, Yval)
CGGPvalstats(SG, Xval, Yval, bydim=FALSE)
}
}
