% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmle.R
\name{tmle}
\alias{tmle}
\title{Targeted maximum likelihood (TMLE)}
\usage{
tmle(y, trt, x, ...)
}
\arguments{
\item{y}{numeric vector for the binary outcome}

\item{trt}{numeric vector for the treatment indicator}

\item{x}{data frame containing the treatment indicator and covariates}

\item{...}{Other arguments}
}
\description{
This function implements the TMLE method. Please use our main function causal_multi_treat.R.
}
\examples{
library(CIMTx)
set.seed(3242019)
idata = data_gen(n = 120, ratio =1,scenario = 1)
trt_ind <- as.numeric(idata$trtdat$trt_ind)
all_vars <- idata$trtdat[, -1] #exclude treatment indicator
y <- idata$Yobs
x = idata$trtdat
causal_multi_treat(y = y, x = idata$trtdat, trt = trt_ind,SL.library = c("SL.glm"),
method = "IPTW-Logistics", estimand = "ATE")
}
