% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{summary_tsne_centralities}
\alias{summary_tsne_centralities}
\title{Summarize t-Distributed Stochastic Neighbor Embedding (t-SNE) on centrality measures}
\usage{
summary_tsne_centralities(x, dims = 2, perplexity = 5, scale = TRUE)
}
\arguments{
\item{x}{a list containg the computed cetrality values}

\item{dims}{integer; number of the outpu dimensions(default=2)}

\item{perplexity}{numeric; A flexible measure of the efficient number of neighbors.
The performance of SNE is fairly robust to changes in the perplexity, and typical
values are between 5 and 50.(default=5)}

\item{scale}{Whether the centrality values should be scaled or not(default=TRUE)}
}
\value{
It resturns a list containing below values:

Y	Matrix containing the new representations for the objects

costs	The cost for every object after the final iteration
}
\description{
This function summarize tsne analysis results on centrality measures
}
\seealso{
\code{\link[Rtsne]{Rtsne}}
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
