% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omniRLRT_fast.R
\name{omniRLRT_fast}
\alias{omniRLRT_fast}
\title{Composite kernel machine regression based restricted likelihood ratio test}
\usage{
omniRLRT_fast(y, X, K1, K2, N = 10000, length.rho = 200,
  length.lambda = 21)
}
\arguments{
\item{y}{vector of the continous outcomes.}

\item{X}{the additional covariates.}

\item{K1}{the first kernel corresponding to the genetic main effect.}

\item{K2}{the second kernel corresponding to the genetic and environment interaction effect.}

\item{N}{total number of randomly generated normal variables used to generate the emprical null distribution of LRT. Default value is 10,000.}

\item{length.rho}{the length of rho. Default value is 21. The values of rho are between 0 and 1.}

\item{length.lambda}{the length of lambda. Dafult value is 200. The values of lambda are all more than 0.}
}
\value{
the result is a list containing three elements. 1. p.dir is the p-value of restricted likelihood ratio test based on emprical distrition. 2. p.aud is the p-value by approximating the null distribution as a mixture of a point mass at zero with probability b and weighted chi square distribution with d degrees of freedom with probality of 1-b. 3. LR is the likelihood ratio test statistics.
}
\description{
Composite kernel machine regression based restricted likelihood ratio test
}
\examples{
set.seed(6)
n = 50 # the number of observations
X = rnorm(n) # the other covariates
p = 2 # two snp in a gene will be simulated
G = runif(n*p)< 0.5
G = G + runif(n*p) < 0.5
G = matrix(G, n,p) #genetic matrix
E = (runif(n) < 0.5)^2 #enviroment effect
y = rnorm(n) + G[,1] * 0.3 #observations
omniRLRT_fast(y, X =  cbind(X, E),K1 = G \%*\% t(G),K2 = (G*E) \%*\% t(G * E))
}
