% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leslie_from_spip.R
\name{leslie_from_spip}
\alias{leslie_from_spip}
\title{Return a Leslie-like matrix from the spip parameters}
\usage{
leslie_from_spip(P, C)
}
\arguments{
\item{P}{a named list of the spip parameters.}

\item{C}{the constant size of the newborn cohort each year}
}
\value{
This function returns a list with the following components:
\itemize{
\item \code{stable_age_distro_fem}: a vector of the expected number of females in each age
group of 0 up to MaxAge-1 once the stable age distribution has been reached.  Note that
this corresponds to the PREKILL_CENSUS from spip. In this vector, the size of the
MaxAge group is left out because this is how it is needed to be to insert into
the \code{--initial-males} and \code{--initial-females} options in spip().  If you want the
size of all age classes, use the output list component
\code{stable_age_distro_fem_with_max_age_class}, described below.
\item \code{stable_age_distro_male}: same as above, but for males.
\item \code{stable_age_distro_fem_with_max_age_class}: The expected number of females from age 0 to
MaxAge once the stable age distribution has been reached.
\item \code{stable_age_distro_male_with_max_age_class}: same as above, but for females.
\item \code{female_leslie_matrix}: The Leslie matrix implied by the spip parameters in P.
}
}
\description{
Here we take the survival rates for females and males and the sex ratio,
as well as the annual new cohort size (assumed constant),
and we make a leslie-like matrix
to compute the stable age distribution.
}
\examples{
result <- leslie_from_spip(species_1_life_history, 300)

# print the result list:
result
}
