% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.clme.r
\name{plot.clme}
\alias{plot.clme}
\title{S3 method to plot objects of class \code{clme}}
\usage{
\method{plot}{clme}(x, ...)
}
\arguments{
\item{x}{object of class 'clme' to be plotted.}

\item{...}{additional plotting arguments.}
}
\description{
Generates a basic plot of estimated coefficients which are subject to constraints (\eqn{\theta_1}{theta_1} ). Lines indicate individual constraints (not global tests) and significance.
}
\note{
While it is possible to plot the output of a clme fit, this will only plot the fitted means.
To indicate significance, plotting must be performed on the summary of a clme fit. This method
will change the class so that plot.summary.clme will be called properly.
}
\examples{
\dontrun{
  set.seed( 42 )
  data( rat.blood )
  cons <- list(order = "simple", decreasing = FALSE, node = 1 )
  clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood ,
                   constraints = cons, seed = 42, nsim = 10)
  plot( clme.out )
}
}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}
\code{\link{plot.summary.clme}}
}

