% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_future_cables_132kv.R
\name{pof_future_cables_132kv}
\alias{pof_future_cables_132kv}
\title{Future Probability of Failure for 132kV cables}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
pof_future_cables_132kv(
  cable_type = "132kV UG Cable (Gas)",
  sub_division = "Aluminium sheath - Aluminium conductor",
  utilisation_pct = "Default",
  operating_voltage_pct = "Default",
  sheath_test = "Default",
  partial_discharge = "Default",
  fault_hist = "Default",
  leakage = "Default",
  reliability_factor = "Default",
  age,
  simulation_end_year = 100
)
}
\arguments{
\item{cable_type}{String.
A sting that refers to the specific asset category.
See See page 17, table 1 in CNAIM (2021).
Options:
\code{cable_type = c("132kV UG Cable (Gas)", "132kV UG Cable (Gas)",
"132kV UG Cable (Non Pressurised)")
}. The default setting is
\code{cable_type = "132kV UG Cable (Gas)"}.}

\item{sub_division}{String. Refers to material the sheath and conductor is
made of. Options:
\code{sub_division = c("Aluminium sheath - Aluminium conductor",
"Aluminium sheath - Copper conductor",
"Lead sheath - Aluminium conductor", "Lead sheath - Copper conductor")
}}

\item{utilisation_pct}{Numeric. The max percentage of utilisation
under normal operating conditions.}

\item{operating_voltage_pct}{Numeric. The ratio in percent of
operating/design voltage.}

\item{sheath_test}{String. Only applied for non pressurised cables.
Indicating the state of the sheath. Options:
\code{sheath_test = c("Pass", "Failed Minor", "Failed Major",
"Default")}. See page 157, table 184 in CNAIM (2021).}

\item{partial_discharge}{String. Only applied for non pressurised cables.
Indicating the level of partial discharge. Options:
\code{partial_discharge = c("Low", "Medium", "High",
 "Default")}. See page 157, table 185 in CNAIM (2021).}

\item{fault_hist}{Numeric. Only applied for non pressurised cables.
The calculated fault rate for the cable in the period per kilometer.
A setting of \code{"No historic faults recorded"}
indicates no fault. See page 157, table 186 in CNAIM (2021).}

\item{leakage}{String. Only applied for oil and gas pressurised cables.
Options:
\code{leakage = c("No (or very low) historic leakage recorded",
"Low/ moderate", "High", "Very High", "Default")}.
See page 158, table 187 (oil) and 188 (gas) in CNAIM (2021).}

\item{reliability_factor}{Numeric. \code{reliability_factor}
shall have a value between 0.6 and 1.5. A setting of \code{"Default"}
 sets the \code{reliability_factor} to 1.
See section 6.14 on page 73 in CNAIM (2021).}

\item{age}{Numeric. The current age in years of the cable.}

\item{simulation_end_year}{Numeric. The last year of simulating probability
of failure. Default is 100.}
}
\value{
Numeric array. Future probability of failure
per annum per kilometre for 132kV cables.
}
\description{
This function calculates the future
annual probability of failure per kilometer for a 132kV cables.
The function is a cubic curve that is based on
the first three terms of the Taylor series for an
exponential function. For more information about the
probability of failure function see section 6
on page 34 in CNAIM (2021).
}
\examples{
# Future probability of failure for 132kV UG Cable (Non Pressurised)
pof_future_cables_132kv(cable_type = "132kV UG Cable (Non Pressurised)",
sub_division = "Aluminium sheath - Aluminium conductor",
utilisation_pct = 75,
operating_voltage_pct = 50,
sheath_test = "Default",
partial_discharge = "Default",
fault_hist = "Default",
leakage = "Default",
reliability_factor = "Default",
age = 1,
simulation_end_year = 100)
}
