% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_sub_cables.R
\name{safety_cof_sub_cables}
\alias{safety_cof_sub_cables}
\title{Safety cost of Failure for Sub cables}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
safety_cof_sub_cables(sub_cable_asset_category)
}
\arguments{
\item{sub_cable_asset_category}{String The type of sub cable asset category}
}
\value{
Numeric. Safety consequences of failure for Sub cables
}
\description{
This function calculates safety consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Safety consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
safety_cof_sub_cables(sub_cable_asset_category = "HV Sub Cable")
}
