% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGlobalRescalingStats.R
\name{getGlobalRescalingStats}
\alias{getGlobalRescalingStats}
\title{Calculate several base statistics for color rescaling.}
\usage{
getGlobalRescalingStats(whole_matrix, saveToDisk = F, output_fn = NULL)
}
\arguments{
\item{whole_matrix}{the whole matrix to get stats for.}

\item{saveToDisk}{Save the statistics to disk as an RDS file in the local directory?}

\item{output_fn}{the name of the output file.}
}
\value{
A list of the output statistics, including:
the global min, max, length, sigma (matrix variance), pos_sigma (variance of the positive values), neg_sigma(variance of the negative values), global mean (global_mu),
 est_max_cap (global_mu+global_sigma_pos*2), as well as the number of rows and columns of the matrix.
}
\description{
calculates several statistics from a large matrix that can then be applied to smaller submatrices without needing to load the entire matrix into memmory
}
\examples{
load(system.file("extdata","nbl_result_matrix_sign_small.rda",package = "CNVScope"))
getGlobalRescalingStats(nbl_result_matrix_sign_small)
}
\keyword{color}
\keyword{rescale}
\keyword{stats}
