% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_rew8r.R
\name{iplotCorr}
\alias{iplotCorr}
\title{Correlation heatmap}
\usage{
iplotCorr(
  COIN,
  aglevs = NULL,
  insig = FALSE,
  levs = TRUE,
  grouprects = TRUE,
  flagcolours = TRUE,
  corthresh = NULL,
  showvals = TRUE,
  cortype = "pearson",
  useweights = NULL
)
}
\arguments{
\item{COIN}{The COIN object}

\item{aglevs}{A two length vector specifying which level to plot against which level. E.g. \code{c(2,4)} for
COIN plots sub-pillars against sub-indexes. If \code{NULL}, plots everything against everything.}

\item{insig}{Logical: if \code{TRUE}, all correlation values are plotted; if \code{FALSE} (default), does not plot insignificant correlations.}

\item{levs}{Logical: if \code{TRUE}, plots lines showing the division between different levels. Only works if \code{aglevs = NULL}.}

\item{grouprects}{Logical: if \code{TRUE}, plots rectangles showing aggregation groups.}

\item{flagcolours}{If \code{TRUE} uses a discrete colour scale specified by \code{corthresh}. Otherwise uses a continuous colour map.}

\item{corthresh}{A named list specifying the colour thresholds to use if \code{flagcolours = TRUE}. Entries should
specify correlation thresholds and can specify any of \code{clow}, \code{cmid} and \code{chi}. Anything below \code{clow} will be
coloured red. Anything between \code{clow} and \code{cmid} will be grey. Anything between \code{cmid} and \code{chigh} will be blue.
Anything above \code{chigh} will be green. Default is \code{list(clow = -0.4, cmid = 0.4, chigh = 0.85)}. You can
specify a subset of these and the others will revert to defaults.}

\item{showvals}{Logical: if \code{TRUE}, overlays correlation values on each square.}

\item{cortype}{The type of correlation: either \code{"pearson"} (default), \code{"spearman"} or \code{"kendall"}. See \link[stats:cor]{stats::cor}.}

\item{useweights}{An optional list of weights to use (this is used mainly in the \code{\link[=rew8r]{rew8r()}} app).}
}
\value{
A \strong{plotly} correlation map (figure).
}
\description{
Plots an interactive heatmap of a correlation matrix. Currently this only works with the
aggregated data set, i.e. you need to have aggregated the data first before using this.
}
\details{
This is a slightly involved wrapper for \strong{plotly}. It allows plotting any level against any other, and outputs correlation
heat maps as HTML widgets. It has some flexibility regarding grouping of indicators, colouring, treatment of insignificant correlations,
and the correlation type. Explore the arguments and see.
}
\examples{
# build ASEM COIN up to aggregation
ASEM <- build_ASEM()
# correlation heatmap of pillars against sub-indexes
iplotCorr(ASEM, aglevs = c(2,3))

}
\seealso{
\itemize{
\item \code{\link[=plotCorr]{plotCorr()}} Static correlation heat maps
\item \code{\link[=rew8r]{rew8r()}} Interactive app for adjusting weights and seeing effects on correlations
\item \code{\link[=getCorr]{getCorr()}} Get correlations between indicators/levels
}
}
