% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{combineDataFromMultipleFiles}
\alias{combineDataFromMultipleFiles}
\title{Combine data from multiple files}
\usage{
combineDataFromMultipleFiles(yConcentration, xConcentration, replNo, file,
  totalNumberofReplicates, siReplicates)
}
\arguments{
\item{yConcentration}{Y drug concentrations}

\item{xConcentration}{X drug concentrations}

\item{replNo}{Number of Replicates in all files}

\item{file}{File name}

\item{totalNumberofReplicates}{Total number of replicates per files}

\item{siReplicates}{data}
}
\value{
Combined data of replicate survival indices from multiple experiments
}
\description{
Combine data from multiple files
}
\examples{
xConc <- c(0.00,  0.20,  0.39,  0.78,  1.56,  3.12,  6.25, 12.50, 25.00, 50) 
yConc <- c(128,  64,  32,  16,   8,   4,   2,   0)
rN <- 4
fN <- 1
trN <- 4
dataFile <- system.file("extdata", "rawDataPreProcessed.csv", package="COMBIA")
dataSample <- read.csv(dataFile, header=FALSE )
replList <- list(vector, 4)
for( i in 1:4)
{ replList[[i]] <- dataSample[i,] }
rslt <- combineDataFromMultipleFiles(list(yConc), 
list(xConc), rN,fN,trN, replList )
}
\author{
Muhammad kashif
}
