% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{readOtherValues}
\alias{readOtherValues}
\title{Read data from raw format and clean for outliers}
\usage{
readOtherValues(file, sheet, rskip = 0, cStart = 1, wellRangesExcel,
  platetype, minThersholdForCVCal, minThersholdForCV, survivalFunc,
  xConcentration, yConcentration)
}
\arguments{
\item{file}{Name of fiele to be read}

\item{sheet}{Sheet}

\item{rskip}{Number of rows to skip before reading data, default rskip=0}

\item{cStart}{Number of column to start reading data, default cStart=1}

\item{wellRangesExcel}{well ranges in excel formate}

\item{platetype}{384 or 96}

\item{minThersholdForCVCal}{Thresolld for data outliears in CV}

\item{minThersholdForCV}{Thresold of values in CV not to remove}

\item{survivalFunc}{A function to calculate survival values}

\item{xConcentration}{Concentrations of drug at x-axis}

\item{yConcentration}{Concentrations of drugs at y-axis}
}
\value{
Matrix of survival values of experimental replicates
}
\description{
Read data from raw format and clean for outliers
}
\examples{
fl <- system.file("extdata", "FluoOptima_384_2014-03-28test.csv", package="COMBIA")
wls <- list(  c(  "K1:K8", "L1:L8","A1:J8",     "K9:K16", "L9:L16","A9:J16", 
                  "W1:W8", "X1:X8","M1:V8",     "W9:W16", "X9:X16","M9:V16")
                  )
sh <- 1
rskip <- 0 
cStart <- 1
pltype <- "384"
minThersholdForCVCal <- 0.1
minThersholdForCV<- 0.3
survivalFunc <- function (x,y,z) {(x-z)/(y-z)}
xConc <- c(0.00,  0.20,  0.39,  0.78,  1.56,  3.12,  6.25, 12.50, 25.00, 50.00) 
yConc <- c(128,  64,  32,  16,   8,   4,   2,   0)
rslt <- readOtherValues(fl, sh, rskip, cStart, wls, pltype, minThersholdForCVCal, 
                minThersholdForCV, survivalFunc, xConc, yConc )
}
\author{
Muhammad kashif
}
