% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmp.R
\name{CMP Distribution}
\alias{CMP Distribution}
\alias{dcmp}
\alias{rcmp}
\alias{pcmp}
\alias{qcmp}
\title{COM-Poisson Distribution}
\usage{
dcmp(x, lambda, nu, log = FALSE)

rcmp(n, lambda, nu)

pcmp(x, lambda, nu)

qcmp(q, lambda, nu, log.p = FALSE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{lambda}{rate parameter.}

\item{nu}{dispersion parameter.}

\item{log}{logical; if TRUE, probabilities are returned on log-scale.}

\item{n}{number of observations.}

\item{q}{vector of probabilities.}

\item{log.p}{logical; if TRUE, probabilities \code{p} are given as \eqn{\log(p)}.}
}
\value{
\itemize{
\item \code{dcmp} gives the density,
\item \code{pcmp} gives the cumulative probability,
\item \code{qcmp} gives the quantile function, and
\item \code{rcmp} generates random values.
}
}
\description{
Functions for the COM-Poisson distribution.
}
\references{
Kimberly F. Sellers & Galit Shmueli (2010). A Flexible Regression Model for
Count Data. Annals of Applied Statistics, 4(2), 943-961.
}
\author{
Kimberly Sellers
}
\keyword{COM-Poisson}
\keyword{distribution}
