% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CONDOP.R
\name{pre.processing}
\alias{pre.processing}
\title{Normalize the data before the classification step.}
\usage{
pre.processing(OPs, NOPs, POPs, DOPs, type = "n0", verbose = TRUE, ...)
}
\arguments{
\item{OPs}{Data table including the confirmed operon pairs (OPs). See \code{select.ops}.}

\item{POPs}{Data table including gene pairs with an operon status to (re)define (POPs). See \code{select.pops}.}

\item{DOPs}{Data table including the operon pairs annotated in DOOR database (DOPs). See \code{select.ops.indoor}.}

\item{type}{Charcater vector indicating the method to use for the normalization step. Default value is "n0".}

\item{verbose}{Default logical value is TRUE.}

\item{OPs}{Data table including the confirmed non-operon pairs (NOPs). See \code{select.nops}.}
}
\description{
n0 - without normalization
n1 - standardization ((x-mean)/sd)
n2 - positional standardization ((x-median)/mad)
n3 - unitization ((x-mean)/range)
n4 - unitization with zero minimum ((x-min)/range)
n5 - normalization in range <-1,1> ((x-mean)/max(abs(x-mean)))
}
\author{
Vittorio Fortino
pre.processing()
}
\keyword{internal}

