% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CONDOP.R
\name{select.nops}
\alias{select.nops}
\title{Define a set of NOPs which is used to train the operon classifier.}
\usage{
select.nops(genes.and.operons, OPs, transcCDSs, transcIGRs.pos, transcIGRs.neg,
  POSSs, POESs, wseq, max.start.transc = c(0.1, 0.1),
  max.end.transc = c(0.1, 0.1), verbose = TRUE, ...)
}
\arguments{
\item{genes.and.operons}{Data table merging gene(s) and operon(s) annotations. See \code{join.genes.and.operons}.}

\item{OPs}{Data table including the confirmed operon pairs (OPs). See \code{select.ops }.}

\item{transcCDSs}{Transcription levels for the coding regions. See \code{comp.gene.transc.levels}.}

\item{transcIGRs.pos}{Transcription levels for the intergenic regions (forard strand). See \code{comp.igr.transc.levels}.}

\item{transcIGRs.neg}{Transcription levels for the intergenic regions (reverse strand). See \code{comp.igr.transc.levels}.}

\item{POSSs}{Data table representing a set of putative operon start-points.}

\item{POESs}{Data table representing a set of putative operon end-points.}

\item{wseq}{Sequence genome.}

\item{max.start.transc}{Cutoff values for the start transcription points. Default values is 0.1.}

\item{max.end.transc}{Cutoff values for the end transcription points. Default values is 0.1.}

\item{verbose}{Default logical value is TRUE.}
}
\description{
Build a data table containing confirmed non-operon pairs (NOPs) and the feature values.
}
\author{
Vittorio Fortino
select.nops()
}
\keyword{internal}

