% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ElementRecog.R
\name{ElementRecog}
\alias{ElementRecog}
\title{ElementRecog is a function to identify COREs}
\usage{
ElementRecog(InputData, windowSize_Vec, peakNumMax, peakNumMin)
}
\arguments{
\item{InputData}{The input data as a table including chromosome regions
in which the first column is chromosome annotation, and second and third
columns are start and ending positions.}

\item{windowSize_Vec}{Vector of window sizes ordered based on order of CORE}

\item{peakNumMax}{Maximum order of COREs (e.g. maximum number of peaks within COREs)}

\item{peakNumMin}{Minimum order of COREs (e.g. minimum number of peaks within COREs)}
}
\value{
Identified COREs for the given input regions
}
\description{
ElementRecog is a function to identify COREs
}
\examples{
InputData <- read.table(system.file("extdata", "A549_Chr21.bed",
package = "CREAM"), sep="\\t")
colnames(InputData) <- c("chr", "start", "end")
MinLength <- 1000
if(nrow(InputData) < MinLength){
   stop(paste( "Number of functional regions is less than ", MinLength,
   ".", sep = "", collapse = ""))
}
peakNumMin <- 2
WScutoff <- 1.5
WindowVecFinal <- WindowVec(InputData, peakNumMin, WScutoff)
OutputList <- ElementRecog(InputData, WindowVecFinal,
(1+length(WindowVecFinal)), peakNumMin)
}
