% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_col_transparent.R
\name{ch_col_transparent}
\alias{ch_col_transparent}
\title{Add Transparency to plot colours}
\usage{
ch_col_transparent(colour, trans)
}
\arguments{
\item{colour}{colour that is to be made transparent, or an array of colours}

\item{trans}{an integer (or array of integers) describing the degree of 
transparency, 0 to 255. Must be the same length as colour. Values < 10 (very transparent),
values > 200 (solid colour).}
}
\value{
\item{res}{returned updated colour code with transparency}
}
\description{
Adds transparency to a colour based on an integer between 0 and 255,
with  0 being fully transparent and 255 being opaque. Based on function 
\code{rvn_col_transparent} in package \pkg{RavenR}.
}
\examples{

 # plot randomly distributed data
plot(rnorm(20), col='black')

# create a transparent blue colour for plotting
mycol <- ch_col_transparent('blue', 100)

# plot more random points in transparent blue colour
points(rnorm(20),col = mycol)

 # plot randomly distributed data
plot(rnorm(20), col = 'blue')

# create two transparent colour for plotting
mycol <- ch_col_transparent(c('green',"red"), c(100, 200))

# plot more random points in transparent colours
points(rnorm(20), col = mycol[2])


}
\references{
See original code on post in Stack Overflow \url{https://stackoverflow.com/questions/12995683/any-way-to-make-plot-points-in-scatterplot-more-transparent-in-rmaking}
}
\author{
Rob Chlumsky; Paul Whitfield
}
\keyword{colour}
\keyword{transparency}
