% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varcovcubshe.R
\name{varcovcubshe}
\alias{varcovcubshe}
\title{Variance-covariance matrix for CUB models with shelter effect}
\usage{
varcovcubshe(m, pai1, pai2, csi, shelter, n)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{pai1}{Parameter of the mixture distribution: mixing coefficient for the shifted Binomial component}

\item{pai2}{Second parameter of the mixture distribution: mixing coefficient for the discrete Uniform component}

\item{csi}{Feeling parameter}

\item{shelter}{Category corresponding to the shelter choice}

\item{n}{Number of observations}
}
\description{
Compute the variance-covariance matrix of parameter estimates of a CUB model with shelter effect.
}
\details{
The function checks if the variance-covariance matrix is positive-definite: if not, it returns a warning
 message and produces a matrix with NA entries.
}
\references{
Iannario, M. (2012), Modelling shelter choices in ordinal data surveys. 
Statistical Modelling and Applications, \bold{21}, 1--22
}
\seealso{
\code{\link{cubshe}},  \code{\link{probcubshe1}}
}
\keyword{internal}

