% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_kernel.R
\name{kernel_nn}
\alias{kernel_nn}
\title{Generating A Single Matrix-wise Function Using Neural Network}
\usage{
kernel_nn(l, p, sigma)
}
\arguments{
\item{l}{(numeric) A numeric number indicating the hyperparameter
(flexibility) of a specific kernel.}

\item{p}{(integer) For polynomial, p is the power; for matern, v = p + 1 /
2; for rational, alpha = p.}

\item{sigma}{(numeric) The covariance coefficient for neural network kernel.}
}
\value{
\item{matrix_wise}{(function) A function calculating the relevance
of two matrices.}
}
\description{
Generate matrix-wise functions for two matrices using neural network kernel.
}
\details{
\bold{Neural Network Kernels} \deqn{k_{NN}(x,
x')=\frac{2}{\pi}sin^{-1}\Big(\frac{2\tilde{x}^T
\tilde{x}'}{\sqrt{(1+2\tilde{x}^T \tilde{x})(1+2\tilde{x}'^T
\tilde{x}')}}\Big)}
}
\references{
The MIT Press. Gaussian Processes for Machine Learning, 2006.
}
\author{
Wenying Deng
}
