% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glpk_solver.R
\docType{class}
\name{GLPK-class}
\alias{GLPK-class}
\alias{GLPK}
\alias{lp_capable,GLPK-method}
\alias{socp_capable,GLPK-method}
\alias{sdp_capable,GLPK-method}
\alias{exp_capable,GLPK-method}
\alias{mip_capable,GLPK-method}
\alias{name,GLPK-method}
\alias{import_solver,GLPK-method}
\alias{Solver.solve,GLPK-method}
\alias{format_results,GLPK-method}
\title{The GLPK class}
\usage{
GLPK()

\S4method{lp_capable}{GLPK}(solver)

\S4method{socp_capable}{GLPK}(solver)

\S4method{sdp_capable}{GLPK}(solver)

\S4method{exp_capable}{GLPK}(solver)

\S4method{mip_capable}{GLPK}(solver)

\S4method{name}{GLPK}(object)

\S4method{import_solver}{GLPK}(solver)

\S4method{Solver.solve}{GLPK}(solver, objective, constraints, cached_data,
  warm_start, verbose, ...)

\S4method{format_results}{GLPK}(solver, results_dict, data, cached_data)
}
\arguments{
\item{object, solver}{A \linkS4class{GLPK} object.}

\item{objective}{A list representing the canonicalized objective.}

\item{constraints}{A list of canonicalized constraints.}

\item{cached_data}{A list mapping solver name to cached problem data.}

\item{warm_start}{A logical value indicating whether the previous solver result should be used to warm start.}

\item{verbose}{A logical value indicating whether to print solver output.}

\item{...}{Additional arguments to the solver.}

\item{results_dict}{A list containing the solver output.}

\item{data}{A list containing information about the problem.}
}
\description{
This class is an interface for Gnu Linear Programming Toolkit solver
}
\section{Methods (by generic)}{
\itemize{
\item \code{lp_capable}: GLPK can handle linear programs.

\item \code{socp_capable}: GLPK can handle second-order cone programs.

\item \code{sdp_capable}: GLPK can handle semidefinite programs.

\item \code{exp_capable}: GLPK cannot handle exponential cone programs.

\item \code{mip_capable}: GLPK cannot handle mixed-integer programs.

\item \code{name}: The name of the solver.

\item \code{import_solver}: Imports the Rgpkk library.

\item \code{Solver.solve}: Call the solver on the canonicalized problem.

\item \code{format_results}: Convert raw solver output into standard list of results.
}}

\seealso{
the \href{https://www.gnu.org/software/glpk/}{Gnu GLKP site}.
}
