% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable.R
\docType{class}
\name{NonNegative-class}
\alias{NonNegative-class}
\alias{.NonNegative}
\alias{NonNegative}
\alias{as.character,NonNegative-method}
\alias{canonicalize,NonNegative-method}
\alias{is_positive,NonNegative-method}
\alias{is_negative,NonNegative-method}
\title{The NonNegative class.}
\usage{
NonNegative(rows = 1, cols = 1, name = NA_character_)

\S4method{as.character}{NonNegative}(x)

\S4method{canonicalize}{NonNegative}(object)

\S4method{is_positive}{NonNegative}(object)

\S4method{is_negative}{NonNegative}(object)
}
\arguments{
\item{rows}{The number of rows in the variable.}

\item{cols}{The number of columns in the variable.}

\item{name}{(Optional) A character string representing the name of the variable.}

\item{x, object}{A \linkS4class{NonNegative} object.}
}
\description{
This class represents a variable constrained to be non-negative.
}
\section{Methods (by generic)}{
\itemize{
\item \code{canonicalize}: Enforce that the variable be non-negative.

\item \code{is_positive}: Always true since the variable is non-negative.

\item \code{is_negative}: Always false since the variable is non-negative.
}}

\section{Slots}{

\describe{
\item{\code{id}}{(Internal) A unique identification number used internally.}

\item{\code{rows}}{The number of rows in the variable.}

\item{\code{cols}}{The number of columns in the variable.}

\item{\code{name}}{(Optional) A character string representing the name of the variable.}

\item{\code{primal_value}}{(Internal) The primal value of the variable stored internally.}
}}

\examples{
x <- NonNegative(3, 3)
as.character(x)
canonicalize(x)
is_positive(x)
is_negative(x)
}
