% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{Pnorm-class}
\alias{Pnorm-class}
\alias{.Pnorm}
\alias{Pnorm}
\alias{validate_args,Pnorm-method}
\alias{name,Pnorm-method}
\alias{to_numeric,Pnorm-method}
\alias{sign_from_args,Pnorm-method}
\alias{is_atom_convex,Pnorm-method}
\alias{is_atom_concave,Pnorm-method}
\alias{is_incr,Pnorm-method}
\alias{is_decr,Pnorm-method}
\alias{is_pwl,Pnorm-method}
\alias{get_data,Pnorm-method}
\alias{graph_implementation,Pnorm-method}
\title{The Pnorm class.}
\usage{
Pnorm(x, p = 2, axis = NA_real_, max_denom = 1024)

\S4method{validate_args}{Pnorm}(object)

\S4method{name}{Pnorm}(object)

\S4method{to_numeric}{Pnorm}(object, values)

\S4method{sign_from_args}{Pnorm}(object)

\S4method{is_atom_convex}{Pnorm}(object)

\S4method{is_atom_concave}{Pnorm}(object)

\S4method{is_incr}{Pnorm}(object, idx)

\S4method{is_decr}{Pnorm}(object, idx)

\S4method{is_pwl}{Pnorm}(object)

\S4method{get_data}{Pnorm}(object)

\S4method{graph_implementation}{Pnorm}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{x}{An \linkS4class{Expression} representing a vector or matrix.}

\item{p}{A number greater than or equal to 1, or equal to positive infinity.}

\item{axis}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}

\item{max_denom}{The maximum denominator considered in forming a rational approximation for \eqn{p}.}

\item{object}{A \linkS4class{Pnorm} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the vector p-norm.
}
\details{
If given a matrix variable, \code{Pnorm} will treat it as a vector and compute the p-norm of the concatenated columns.

For \eqn{p \geq 1}, the p-norm is given by \deqn{\|x\|_p = \left(\sum_{i=1}^n |x_i|^p\right)^{1/p}} with domain \eqn{x \in \mathbf{R}^n}.
For \eqn{p < 1, p\neq 0}, the p-norm is given by \deqn{\|x\|_p = \left(\sum_{i=1}^n x_i^p\right)^{1/p}} with domain \eqn{x \in \mathbf{R}^n_+}.

\itemize{
   \item Note that the "p-norm" is actually a \strong{norm} only when \eqn{p \geq 1} or \eqn{p = +\infty}. For these cases, it is convex.
   \item The expression is undefined when \eqn{p = 0}.
   \item Otherwise, when \eqn{p < 1}, the expression is concave, but not a true norm.
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{validate_args}: Check that the arguments are valid.

\item \code{name}: The name and arguments of the atom.

\item \code{to_numeric}: The p-norm of \code{x}.

\item \code{sign_from_args}: The atom is positive.

\item \code{is_atom_convex}: The atom is convex if \eqn{p \geq 1}.

\item \code{is_atom_concave}: The atom is concave if \eqn{p < 1}.

\item \code{is_incr}: The atom is weakly increasing if \eqn{p < 1} or \eqn{p \geq 1} and \code{x} is positive.

\item \code{is_decr}: The atom is weakly decreasing if \eqn{p \geq 1} and \code{x} is negative.

\item \code{is_pwl}: The atom is piecewise linear only if \code{x} is piecewise linear, and either \eqn{p = 1} or \eqn{p = \infty}.

\item \code{get_data}: Returns \code{list(p, axis)}.

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} representing a vector or matrix.}

\item{\code{p}}{A number greater than or equal to 1, or equal to positive infinity.}

\item{\code{max_denom}}{The maximum denominator considered in forming a rational approximation for \eqn{p}.}

\item{\code{axis}}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}

\item{\code{.approx_error}}{(Internal) The absolute difference between \eqn{p} and its rational approximation.}
}}

