% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{conv}
\alias{conv}
\title{Discrete Convolution}
\usage{
conv(lh_exp, rh_exp)
}
\arguments{
\item{lh_exp}{An \linkS4class{Expression} or vector representing the left-hand value.}

\item{rh_exp}{An \linkS4class{Expression} or vector representing the right-hand value.}
}
\value{
An \linkS4class{Expression} representing the convolution of the input.
}
\description{
The 1-D discrete convolution of two vectors.
}
\examples{
set.seed(129)
x <- Variable(5)
h <- matrix(stats::rnorm(2), nrow = 2, ncol = 1)
prob <- Problem(Minimize(sum(conv(h, x))))
result <- solve(prob)
result$value
result$getValue(x)
}
