% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{NormInf-class}
\alias{NormInf-class}
\alias{.NormInf}
\alias{NormInf}
\alias{name,NormInf-method}
\alias{to_numeric,NormInf-method}
\alias{allow_complex,NormInf-method}
\alias{sign_from_args,NormInf-method}
\alias{is_atom_convex,NormInf-method}
\alias{is_atom_concave,NormInf-method}
\alias{is_atom_log_log_convex,NormInf-method}
\alias{is_atom_log_log_concave,NormInf-method}
\alias{is_incr,NormInf-method}
\alias{is_decr,NormInf-method}
\alias{is_pwl,NormInf-method}
\alias{get_data,NormInf-method}
\alias{.domain,NormInf-method}
\alias{.grad,NormInf-method}
\alias{.column_grad,NormInf-method}
\title{The NormInf class.}
\usage{
\S4method{name}{NormInf}(x)

\S4method{to_numeric}{NormInf}(object, values)

\S4method{allow_complex}{NormInf}(object)

\S4method{sign_from_args}{NormInf}(object)

\S4method{is_atom_convex}{NormInf}(object)

\S4method{is_atom_concave}{NormInf}(object)

\S4method{is_atom_log_log_convex}{NormInf}(object)

\S4method{is_atom_log_log_concave}{NormInf}(object)

\S4method{is_incr}{NormInf}(object, idx)

\S4method{is_decr}{NormInf}(object, idx)

\S4method{is_pwl}{NormInf}(object)

\S4method{get_data}{NormInf}(object)

\S4method{.domain}{NormInf}(object)

\S4method{.grad}{NormInf}(object, values)

\S4method{.column_grad}{NormInf}(object, value)
}
\arguments{
\item{x, object}{A \linkS4class{NormInf} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}

\item{value}{A numeric value}
}
\description{
This class represents the infinity-norm.
}
\section{Methods (by generic)}{
\itemize{
\item \code{name(NormInf)}: The name and arguments of the atom.

\item \code{to_numeric(NormInf)}: Returns the infinity norm of \code{x}.

\item \code{allow_complex(NormInf)}: Does the atom handle complex numbers?

\item \code{sign_from_args(NormInf)}: The atom is always positive.

\item \code{is_atom_convex(NormInf)}: The atom is convex.

\item \code{is_atom_concave(NormInf)}: The atom is not concave.

\item \code{is_atom_log_log_convex(NormInf)}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave(NormInf)}: Is the atom log-log concave?

\item \code{is_incr(NormInf)}: Is the composition weakly increasing in argument \code{idx}?

\item \code{is_decr(NormInf)}: Is the composition weakly decreasing in argument \code{idx}?

\item \code{is_pwl(NormInf)}: Is the atom piecewise linear?

\item \code{get_data(NormInf)}: Returns the axis.

\item \code{.domain(NormInf)}: Returns constraints describing the domain of the node

\item \code{.grad(NormInf)}: Gives the (sub/super)gradient of the atom w.r.t. each variable

\item \code{.column_grad(NormInf)}: Gives the (sub/super)gradient of the atom w.r.t. each column variable

}}
