% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\docType{methods}
\name{linearize}
\alias{linearize}
\title{Affine Approximation to an Expression}
\usage{
linearize(expr)
}
\arguments{
\item{expr}{An \linkS4class{Expression} to linearize.}
}
\value{
An affine expression or \code{NA} if cannot be linearized.
}
\description{
Gives an elementwise lower (upper) bound for convex (concave) expressions that is tight
at the current variable/parameter values. No guarantees for non-DCP expressions.
}
\details{
If f and g are convex, the objective f-g can be (heuristically) minimized using the
implementation below of the convex-concave method:

\code{for(iters in 1:N)
   solve(Problem(Minimize(f - linearize(g))))}
}
