% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affine.R
\docType{class}
\name{Promote-class}
\alias{Promote-class}
\alias{.Promote}
\alias{Promote}
\alias{to_numeric,Promote-method}
\alias{is_symmetric,Promote-method}
\alias{dim_from_args,Promote-method}
\alias{is_atom_log_log_convex,Promote-method}
\alias{is_atom_log_log_concave,Promote-method}
\alias{get_data,Promote-method}
\alias{graph_implementation,Promote-method}
\title{The Promote class.}
\usage{
Promote(expr, promoted_dim)

\S4method{to_numeric}{Promote}(object, values)

\S4method{is_symmetric}{Promote}(object)

\S4method{dim_from_args}{Promote}(object)

\S4method{is_atom_log_log_convex}{Promote}(object)

\S4method{is_atom_log_log_concave}{Promote}(object)

\S4method{get_data}{Promote}(object)

\S4method{graph_implementation}{Promote}(object, arg_objs, dim, data = NA_real_)
}
\arguments{
\item{expr}{An \linkS4class{Expression} or numeric constant.}

\item{promoted_dim}{The desired dimensions.}

\item{object}{A \linkS4class{Promote} object.}

\item{values}{A list containing the value to promote.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{dim}{A vector representing the dimensions of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the promotion of a scalar expression into a vector/matrix.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: Promotes the value to the new dimensions.

\item \code{is_symmetric}: Is the expression symmetric?

\item \code{dim_from_args}: Returns the (row, col) dimensions of the expression.

\item \code{is_atom_log_log_convex}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave}: Is the atom log-log concave?

\item \code{get_data}: Returns information needed to reconstruct the expression besides the args.

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{expr}}{An \linkS4class{Expression} or numeric constant.}

\item{\code{promoted_dim}}{The desired dimensions.}
}}

