% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{sigma_max}
\alias{sigma_max}
\title{Maximum Singular Value}
\usage{
sigma_max(A = A)
}
\arguments{
\item{A}{An \linkS4class{Expression} or matrix.}
}
\value{
An \linkS4class{Expression} representing the maximum singular value.
}
\description{
The maximum singular value of a matrix.
}
\examples{
C <- Variable(3,2)
val <- rbind(c(1,2), c(3,4), c(5,6))
obj <- sigma_max(C)
constr <- list(C == val)
prob <- Problem(Minimize(obj), constr)
result <- solve(prob, solver = "SCS")
result$value
result$getValue(C)
}
