% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{rmvt}
\alias{rmvt}
\title{Multivariate t Distribution.}
\usage{
rmvt(n = 1, mu = rep(0, p), sigma = diag(p), df = Inf)
}
\arguments{
\item{n}{number of samples.}

\item{mu}{mean}

\item{sigma}{a \eqn{k\times k}{k x k} positive definite matrix. If the degree
\eqn{\nu} if bigger than 2 the created covariance is
\deqn{var(x) = \Sigma\frac{\nu}{\nu - 2}}
for \eqn{\nu > 2}.}

\item{df}{degree of freedom \eqn{\nu}.}
}
\value{
a \eqn{n\times p}{n x p} matrix with samples in its rows.
}
\description{
Random generation from multivariate t distribution (student distribution).
}
\examples{
CVarE:::rmvt(20, c(0, 1), matrix(c(3, 1, 1, 2), 2), 3)
CVarE:::rmvt(20, sigma = matrix(c(2, 1, 1, 2), 2), df = 3)
CVarE:::rmvt(20, mu = c(3, -1, 2), df = 3)

}
\keyword{internal}
