% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{\%{}\%}
\alias{\%{}\%}
\title{Infix operator to run background jobs}
\usage{
lhs \%{}\% rhs
}
\arguments{
\item{lhs}{not used, see details and examples}

\item{rhs}{the block of code that you want to run}
}
\value{
prints the ID of the background job in the console and, once completed, the objects created in the block of code
are imported into the global environment
}
\description{
This infix operator can be used to create a background job for a block of code in RStudio/Posit and, once completed,
all objects created in the block of code are imported into the global environment.
}
\details{
You can use this infix operator in two different ways. Either you set the left-hand side to \code{NULL} or you use the syntax
`` `%{}%` ``\code{({BlockOfCode})}
}
\examples{
# Can only be executed in Rstudio
\dontrun{
NULL \%{}\% {
 x = rnorm(1e7)
 y = rnorm(1e7)
}
`\%{}\%` ({
 x = rnorm(1e7)
 y = rnorm(1e7)
})
}
}
