CatDynSum <-
function(x, season, meths)
   {
    if(class(x) != "list")
      {stop("'x' should be a list with each component an output of function CatDynFit(), class 'catdyn'")}
    if(sum(sapply(x,class) == "catdyn") != length(x))
      {stop("'x' should be a list with each component an output of function CatDynFit(), class 'catdyn'")}
    if(length(meths) != length(x))
      {stop("One numerical method for each component of 'x' should be provided")}
    if(unique(sapply(1:length(x), function(u) length(x[[u]]$Data$Properties$Fleets$Fleet)) == 1))
      {
       fleet.name <- unique(sapply(1:length(x), function(u) x[[u]]$Data$Properties$Fleets$Fleet));
       maxP       <- max(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$Type))
       res        <- data.frame(matrix(0,nrow=length(x),ncol=10+3*maxP+7))
       res$X1     <- rep(season,length(x))
       res$X2     <- paste(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$Type),"P",sep="")
       res$X3     <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$Distr)
       res$X4     <- meths
       res$X5     <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$AIC)
       res$X6     <- sapply(1:length(x), function(u) max(abs(x[[u]]$Model[[meths[u]]]$num.grads)))       
       res$X7     <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par["M"]))
       res$X8     <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev["M"])
       res$X9     <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par["N0"]) 
       res$X10    <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev["N0"])
       if(maxP == 0)
         {
          res$X11 <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("k.",fleet.name,sep="")]))
          res$X12 <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("k.",fleet.name,sep="")])
          res$X13 <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("alpha.",fleet.name,sep="")]))
          res$X14 <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("alpha.",fleet.name,sep="")])
          res$X15 <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("beta.",fleet.name,sep="")]))
          res$X16 <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("beta.",fleet.name,sep="")])
          res$X17 <- 0
          names(res) <- c("Season","Model","Distribution","Method","AIC","Max.Abs.Grads.","M","SE.M","N0","SE.N0",
                          paste(c("k.","SE.k.","alpha.","SE.alpha.","beta.","SE.beta."),fleet.name,sep=""),"Sel.Model")
         }
       else
         {
          for(i in 1:length(x))
            {
             if(x[[i]]$Model[[meths[i]]]$Type!=0)
               {
                for(j in 1:x[[i]]$Model[[meths[i]]]$Type)
                  {
                   res[i,11+3*(j-1)] <- x[[i]]$Model[[meths[i]]]$bt.par[paste("P",as.character(j),".",fleet.name,sep="")]
                   res[i,12+3*(j-1)] <- x[[i]]$Model[[meths[i]]]$bt.stdev[paste("P",as.character(j),".",fleet.name,sep="")]
                   res[i,13+3*(j-1)] <- x[[i]]$Model[[meths[i]]]$Dates[1+j]
                  }
               }
            }
          res[,3*maxP+11] <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("k.",fleet.name,sep="")]))
          res[,3*maxP+12] <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("k.",fleet.name,sep="")])          
          res[,3*maxP+13] <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("alpha.",fleet.name,sep="")]))
          res[,3*maxP+14] <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("alpha.",fleet.name,sep="")])      
          res[,3*maxP+15] <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("beta.",fleet.name,sep="")])) 
          res[,3*maxP+16] <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("beta.",fleet.name,sep="")])       
          res[,3*maxP+17] <- 0                                                                                                          
          names(res) <- c("Season","Model","Distribution","Method","AIC","Max.Abs.Grads.","M","SE.M","N0","SE.N0",
                          paste(paste(rep(c("P","SE.P","ts.P"),maxP),sort(rep(as.character(1:maxP),3)),rep(".",maxP),sep=""),fleet.name,sep=""),
                          paste(c("k.","SE.k.","alpha.","SE.alpha.","beta.","SE.beta."),fleet.name,sep=""),
                          "Sel.Model")
         } 
      }   
    else if(anyDuplicated(t(sapply(1:length(x), function(u) unique(x[[u]]$Data$Properties$Fleets$Fleet)))) == 2)
      {
       fleet.name <- unique(sapply(1:length(x), function(u) x[[u]]$Data$Properties$Fleets$Fleet))[,1];
       maxP       <- max(sapply(1:length(x), function(u) sum(x[[u]]$Model[[meths[u]]]$Type)))
       maxPF1     <- max(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$Type)[1,])
       maxPF2     <- max(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$Type)[2,])
       res        <- data.frame(matrix(0,nrow=length(x),ncol=10+3*maxP+13))
       res$X1     <- rep(season,length(x))
       for(i in 1:length(x))
         {
          res$X2[i] <- paste(x[[i]]$Model[[meths[i]]]$Type[1],"P", x[[i]]$Model[[meths[i]]]$Type[2],"P",sep="") 
          res$X3[i] <- paste(t(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$Distr))[i,1],
                             t(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$Distr))[i,2],sep=",")
         }
       res$X4     <- meths
       res$X5     <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$AIC)
       res$X6     <- sapply(1:length(x), function(u) max(abs(x[[u]]$Model[[meths[u]]]$num.grads)))       
       res$X7     <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par["M"]))
       res$X8     <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev["M"])
       res$X9     <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par["N0"]) 
       res$X10    <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev["N0"])
       if(maxP == 0)
         {
          res$X11 <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("k.",fleet.name[1],sep="")]))
          res$X12 <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("k.",fleet.name[1],sep="")])
          res$X13 <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("alpha.",fleet.name[1],sep="")]))
          res$X14 <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("alpha.",fleet.name[1],sep="")])
          res$X15 <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("beta.",fleet.name[1],sep="")]))
          res$X16 <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("beta.",fleet.name[1],sep="")])
          res$X17 <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("k.",fleet.name[2],sep="")]))
          res$X18 <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("k.",fleet.name[2],sep="")])
          res$X19 <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("alpha.",fleet.name[2],sep="")]))
          res$X20 <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("alpha.",fleet.name[2],sep="")])
          res$X21 <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("beta.",fleet.name[2],sep="")]))
          res$X22 <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("beta.",fleet.name[2],sep="")])
          res$X23 <- 0
          names(res) <- c("Season","Model","Distribution","Method","AIC","Max.Abs.Grads.","M","SE.M","N0","SE.N0",
                          paste(c("k.","SE.k.","alpha.","SE.alpha.","beta.","SE.beta."),fleet.name[1],sep=""),
                          paste(c("k.","SE.k.","alpha.","SE.alpha.","beta.","SE.beta."),fleet.name[2],sep=""),
                          "Sel.Model")
         }
       else
         {
          for(i in 1:length(x))
            {
             if(x[[i]]$Model[[meths[i]]]$Type[1]!=0) 
               {
                for(j in 1:x[[i]]$Model[[meths[i]]]$Type[1])
                  {
                   res[i,11+3*(j-1)] <- x[[i]]$Model[[meths[i]]]$bt.par[paste("P",as.character(j),".",fleet.name[1],sep="")]
                   res[i,12+3*(j-1)] <- x[[i]]$Model[[meths[i]]]$bt.stdev[paste("P",as.character(j),".",fleet.name[1],sep="")]
                   res[i,13+3*(j-1)] <- x[[i]]$Model[[meths[i]]]$Dates[1+j]
                  }
                } 
             if(x[[i]]$Model[[meths[i]]]$Type[2]!=0) 
               {
                for(k in 1:x[[i]]$Model[[meths[i]]]$Type[2])
                  {
                   res[i,11+3*(maxPF1)+3*(k-1)] <- x[[i]]$Model[[meths[i]]]$bt.par[paste("P",as.character(k),".",fleet.name[2],sep="")]
                   res[i,12+3*(maxPF1)+3*(k-1)] <- x[[i]]$Model[[meths[i]]]$bt.stdev[paste("P",as.character(k),".",fleet.name[2],sep="")]
                   res[i,13+3*(maxPF1)+3*(k-1)] <- x[[i]]$Model[[meths[i]]]$Dates[1+x[[i]]$Model[[meths[i]]]$Type[1]+k]
                  }
               }
            }
          res[,3*maxP+11] <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("k.",fleet.name[1],sep="")]))    
          res[,3*maxP+12] <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("k.",fleet.name[1],sep="")])          
          res[,3*maxP+13] <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("alpha.",fleet.name[1],sep="")]))
          res[,3*maxP+14] <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("alpha.",fleet.name[1],sep="")])      
          res[,3*maxP+15] <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("beta.",fleet.name[1],sep="")])) 
          res[,3*maxP+16] <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("beta.",fleet.name[1],sep="")])       
          res[,3*maxP+17] <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("k.",fleet.name[2],sep="")]))                      
          res[,3*maxP+18] <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("k.",fleet.name[2],sep="")])                            
          res[,3*maxP+19] <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("alpha.",fleet.name[2],sep="")]))                  
          res[,3*maxP+20] <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("alpha.",fleet.name[2],sep="")])                        
          res[,3*maxP+21] <- unlist(sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.par[paste("beta.",fleet.name[2],sep="")]))                   
          res[,3*maxP+22] <- sapply(1:length(x), function(u) x[[u]]$Model[[meths[u]]]$bt.stdev[paste("beta.",fleet.name[2],sep="")])                         
          res[,3*maxP+23] <- 0                                                                                                          
          names(res) <- c("Season","Model","Distribution","Method","AIC","Max.Abs.Grads.","M","SE.M","N0","SE.N0",
                          paste(paste(rep(c("P","SE.P","ts.P"),maxPF1),sort(rep(as.character(1:maxPF1),3)),rep(".",maxPF1),sep=""),fleet.name[1],sep=""),
                          paste(paste(rep(c("P","SE.P","ts.P"),maxPF2),sort(rep(as.character(1:maxPF2),3)),rep(".",maxPF2),sep=""),fleet.name[2],sep=""),
                          paste(c("k.","SE.k.","alpha.","SE.alpha.","beta.","SE.beta."),fleet.name[1],sep=""),
                          paste(c("k.","SE.k.","alpha.","SE.alpha.","beta.","SE.beta."),fleet.name[2],sep=""),
                          "Sel.Model")
         } 
      } 
    else
      {
       stop("All components of 'x' should have been built with data from the same fleets with the number of fleets > 0 and < 3")
      }
    return(res);
   }
