% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atom_ad_db.R
\name{catr_atom_get_address_db_all}
\alias{catr_atom_get_address_db_all}
\alias{catr_atom_get_address_to}
\alias{catr_atom_get_address_db_to}
\title{ATOM INSPIRE: Reference Database for ATOM Addresses}
\source{
\url{https://www.catastro.minhap.es/INSPIRE/CadastralParcels/ES.SDGC.CP.atom.xml}
}
\usage{
catr_atom_get_address_db_all(
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)

catr_atom_get_address_db_to(
  to,
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{cache}{A logical whether to do caching. Default is \code{TRUE}. See
\strong{About caching} section on \code{\link[=catr_set_cache_dir]{catr_set_cache_dir()}}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source file.}

\item{cache_dir}{A path to a cache directory. On missing value the function
would store the cached files on a temporary dir (See \code{\link[base:tempfile]{base::tempdir()}}).}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{to}{Territorial office. It can be any type of string, the function
would perform a search using \code{\link[base:grep]{base::grep()}}.}
}
\value{
A tibble with the information requested.
\itemize{
\item \code{catr_atom_get_address_db_all()} provides a tibble with the following
fields:
\itemize{
\item \code{territorial_office}: Territorial office, corresponding to each province
of Spain expect Basque Country and Navarre.
\item \code{url}: ATOM url for the corresponding territorial office.
\item \code{munic}: Name of the municipality.
\item \code{date}: Reference date of the data. Note that \strong{the information of
this service is updated twice a year}.
}
\item \code{catr_atom_get_address_db_to()} provides a tibble with the following
fields:
\itemize{
\item \code{munic}: Name of the municipality.
\item \code{url}: url for downloading information of the corresponding municipality.
\item \code{date}: Reference date of the data. Note that \strong{the information of
this service is updated twice a year}.
}
}
}
\description{
Create a database containing the urls provided in the INSPIRE ATOM service
of the Spanish Cadastre for extracting Addresses.
\itemize{
\item \code{catr_atom_get_address_db_all()} provides a top-level table including
information of all the territorial offices (except Basque Country and
Navarre) listing the municipalities included on each office.
\item \code{catr_atom_get_address_db_to()} provides a table for the specified
territorial office including information for each of the municipalities
of that office.
}
}
\examples{
\donttest{
catr_atom_get_address_db_all()
}
}
\seealso{
INSPIRE API functions:
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()},
\code{\link{catr_wms_get_layer}()}

Other INSPIRE ATOM services:
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_atom_search_munic}()}

Other addresses: 
\code{\link{catr_atom_get_address}()},
\code{\link{catr_wfs_get_address_bbox}()}

Other databases: 
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_atom_search_munic}()},
\code{\link{catr_srs_values}}
}
\concept{ATOM}
\concept{INSPIRE}
\concept{addresses}
\concept{databases}
