% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_clear.R
\name{catr_clear_cache}
\alias{catr_clear_cache}
\title{Clear your \CRANpkg{CatastRo} cache dir}
\usage{
catr_clear_cache(config = FALSE, cached_data = TRUE, verbose = FALSE)
}
\arguments{
\item{config}{if \code{TRUE}, will delete the configuration folder of
\CRANpkg{CatastRo}.}

\item{cached_data}{If this is set to \code{TRUE}, it will delete your
\code{cache_dir} and all its content.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
Invisible. This function is called for its side effects.
}
\description{
\strong{Use this function with caution}. This function would clear your cached
data and configuration, specifically:
\itemize{
\item Deletes the \CRANpkg{CatastRo} config directory
(\code{rappdirs::user_config_dir("CatastRo", "R")}).
\item Deletes the \code{cache_dir} directory.
\item Deletes the values on stored on \code{Sys.getenv("CATASTROESP_CACHE_DIR")}.
}
}
\details{
This is an overkill function that is intended to reset your status
as it you would never have installed and/or used \CRANpkg{CatastRo}.
}
\examples{

# Don't run this! It would modify your current state
\dontrun{
catr_clear_cache(verbose = TRUE)
}

Sys.getenv("CATASTROESP_CACHE_DIR")
}
\seealso{
Other cache utilities: 
\code{\link{catr_set_cache_dir}()}
}
\concept{cache utilities}
