% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/wpp.R
\name{summary.wpp}
\alias{summary.wpp}
\title{Summarize Witness Protection Program Outputs}
\usage{
\method{summary}{wpp}(object, ...)
}
\arguments{
\item{object}{an object of class "\code{wpp}", usually a result of a call to \code{\link{wpp}}.}

\item{...}{other parameters, ignored.}
}
\value{
Besides fields inherented from the \code{wpp} object, a list summary statistics is included:
 \item{\code{lq}}{an array of 5 entries corresponding to evenly space quantiles of the lower bound of the ACE of the highest scoring
                 witness/admissible set pair.}
 \item{\code{lci}}{95\% marginal posterior credible interval for the chosen ACE lower bound.}
 \item{\code{uq}}{an array of 5 entries corresponding to evenly space quantiles of the lower bound of the ACE of the highest scoring
                 witness/admissible set pair.}
 \item{\code{uci}}{95\% marginal posterior credible interval for the chosen ACE lower bound.}
 \item{\code{hscore_bound}}{score of the witness/admissible oair of highest score.}
 \item{\code{chosen_w}}{witness of the witness/admissible pair of highest score.}
 \item{\code{chosen_Z}}{admissible set of the witness/admissible set of highest score.}
 \item{\code{min_l}}{estimated minimum lower bound of all lower bounds found by the procedure.}
 \item{\code{max_u}}{estimated maximum upper bound of all upper bounds found by the procedure.}
 \item{\code{narrowest_bound}}{lower and upper bounds corresponding to the narrowest ACE interval found by the procedure.}
}
\description{
\code{summary} method for class "\code{wpp}".
}
\seealso{
The model fitting function \code{\link{wpp}}.
}

