% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CausalKinetiX.R
\name{CausalKinetiX}
\alias{CausalKinetiX}
\title{CausalKinetiX}
\usage{
CausalKinetiX(D, times, env, target, models = NA, pars = list())
}
\arguments{
\item{D}{data matrix. Should have dimension n x (L*d), where n is
the number of repetitions (over all experiments), L is the
number of time points and d is the number of predictor
variables.}

\item{times}{vector of length L specifying the time points at
which data was observed.}

\item{env}{integer vector of length n encoding to which experiment
each repetition belongs.}

\item{target}{integer specifing which variable is the target.}

\item{models}{list of models. Each model is specified by a list of
vectors specifiying the variables included in the interactions
of each term.}

\item{pars}{list of the following parameters: \code{max.preds}
  (default FALSE) if TRUE also models with lower terms included,
  \code{expsize} (default 2) the expected number of terms,
  \code{interactions} (default FALSE) specifies whether to include
  interactions in the models, \code{products} (default FALSE)
  specifies whether to include products in the models,
  \code{include.vars} (default NA) specifies variables that should
  be included in each model, \code{maineffect.models} (default
  FALSE) main-effect models or exhaustive models, \code{screening}
  (default NA) specifies the number of terms remaining after
  screening - NA implies screening, \code{K} (default NA) cutoff
  parameter used in variable ranking.

  Additionally all parameters used in CausalKinetiX.modelranking
  can also be specified here.}
}
\value{
object of class 'CausalKinetiX' consisting of the following
  elements

\item{models}{list of the individually scored models.}
\item{model.scores}{vector containing the score for each model.}
\item{variable.scores}{vector containing the score of each variable.}
\item{ranking}{vector specifying the ranking of each variable.}
}
\description{
Applies CausalKinetiX framework to rank variables and models according to their stability.
}
\details{
For further details see the references.
}
\examples{

## Generate data from Maillard reaction
simulation.obj <- generate.data.maillard(target=6,
                                         env=rep(1:3, 5),
                                         L=15,
                                         seed=5,
                                         par.noise=list(noise.sd=1))

D <- simulation.obj$simulated.data
time <- simulation.obj$time
env <- simulation.obj$env
target <- simulation.obj$target

## Fit data using CausalKinetiX
ck.fit <- CausalKinetiX(D, time, env, target,
                        pars=list(expsize=1,
                                  average.reps=TRUE))
# variable ranking (here the true parent is variable 4)
print(ck.fit$ranking)
}
\references{
Pfister, N., S. Bauer, J. Peters (2018).
Identifying Causal Structure in Large-Scale Kinetic Systems
ArXiv e-prints (arXiv:1810.11776).
}
\seealso{
The function \code{\link{CausalKinetiX.modelranking}} can
  be used if the variable ranking is not required.
}
\author{
Niklas Pfister, Stefan Bauer and Jonas Peters
}
