% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.data.hidden.R
\name{generate.data.hidden}
\alias{generate.data.hidden}
\title{Hidden variable model}
\usage{
generate.data.hidden(env = rep(1, 10), L = 15,
  par.noise = list(noise.sd = 0.01, only.target.noise = TRUE, relativ =
  FALSE), intervention = "initial_blockreactions",
  intervention.par = 0.1, hidden = TRUE, ode.solver = "lsoda",
  seed = NA, silent = FALSE)
}
\arguments{
\item{env}{integer vector of length n encoding to which experiment
each repetition belongs.}

\item{L}{number of time points for evaluation.}

\item{par.noise}{list of parameters that specify the added
noise. \code{noise.sd} specifies the standard deviation of
noise, \code{only.target.noise} specifies whether to only add
noise to target and \code{relative} specifies if the size of the
noise should be relative to size of variable (if TRUE standard
deviation is given by par.noise$noise.sd*(x(t)-x(t-1))).}

\item{intervention}{string specifying type of
intervention. Currently three type of interventions are
implemented "initial" (only intervene on intial values),
"blockreactions" (intervene by blocking random reactions) or
"intial_blockreactions" (intervene on both initial values and
blockreactions").}

\item{intervention.par}{if intervention is either "blockreactions"
or "initial_blockreactions", the rate constant k_7 is set to a
noisy version of k_4. This parameter specifies size of this
noise, more precisely k_7 is set to k_4 + \code{runif(1,
-intervention.par, intervention.par)}.}

\item{hidden}{boolean whether the variables H1 and H2 should be
removed from output.}

\item{ode.solver}{string specifying which ODE solver to use when
solving ODE. Should be one of the methods from the
\code{deSolve} package ("lsoda", "lsode", "lsodes", "lsodar",
"vode", "daspk", "euler", "rk4", "ode23", "ode45", "radau",
"bdf", "bdf_d", "adams", "impAdams", "impAdams_d", "iteration").}

\item{seed}{random seed. Does not work if a "Detected blow-up"
warning shows up.}

\item{silent}{set to TRUE if no status output should be produced.}
}
\value{
list consisting of the following elements

\item{simulated.data}{D-matrix of noisy data.}
\item{time}{vector containing time points}
\item{env}{vector specifying the experimental environment.}
\item{simulated.model}{object returned by ODE solver.}
\item{true.model}{vector specifying the target equation model.}
\item{target}{target variable.}
}
\description{
Generate sample data from the hidden variable model.
}
\details{
For further details see the references.
}
\examples{

simulation.obj <- generate.data.hidden(env=rep(1:5, 3),
                                       L=15,
                                       par.noise=list(noise.sd=0.02,
                                                      only.target.noise=FALSE,
                                                      relativ=TRUE),
                                       intervention="initial_blockreactions",
                                       intervention.par=0.1)

D <- simulation.obj$simulated.data
fulldata <- simulation.obj$simulated.model
time <- simulation.obj$time
plot(fulldata[[1]][,1], fulldata[[1]][,2], type= "l", lty=2,
     xlab="time", ylab="concentration")
points(time, D[1,1:length(time)], col="red", pch=19)
legend("topright", c("true trajectory", "observations"),
       col=c("black", "red"), lty=c(2, NA), pch=c(NA, 19))
}
\references{
Pfister, N., S. Bauer, J. Peters (2018).
Identifying Causal Structure in Large-Scale Kinetic Systems
ArXiv e-prints (arXiv:1810.11776).
}
\seealso{
The functions \code{\link{generate.data.maillard}} and
  \code{\link{generate.data.targetmodel}} allow to simulate ODE
  data from two additional models.
}
\author{
Niklas Pfister, Stefan Bauer and Jonas Peters
}
