% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_restrictions.R
\name{restrict_by_query}
\alias{restrict_by_query}
\title{Reduce nodal types}
\usage{
restrict_by_query(model, statement, join_by = "|", keep = FALSE)
}
\arguments{
\item{model}{a model created by make_model()}

\item{statement}{a list of character vectors specifying nodal types to be removed from the model. Use \code{get_nodal_types} to see syntax.}

\item{join_by}{A string or a list of strings. The logical operator joining expanded types when \code{statement} contains wildcard (\code{.}). Can take values \code{'&'} (logical AND) or \code{'|'} (logical OR). When restriction contains wildcard (\code{.}) and \code{join_by} is not specified, it defaults to \code{'|'}, otherwise it defaults to \code{NULL}.}

\item{keep}{Logical. If `FALSE`, removes and if `TRUE` keeps only causal types specified by \code{restriction}.}
}
\value{
An object of class \code{causal_model}. The causal types and nodal types in the model are reduced according to the stated restriction.
}
\description{
Reduce nodal types
}
\seealso{
Other restrictions: 
\code{\link{restrict_by_labels}()},
\code{\link{set_restrictions}()}
}
\concept{restrictions}
\keyword{internal}
