% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_parameters.R
\name{parameter_setting}
\alias{parameter_setting}
\alias{make_parameters}
\alias{set_parameters}
\alias{get_parameters}
\title{Setting parameters}
\usage{
make_parameters(
  model,
  parameters = NULL,
  param_type = NULL,
  warning = TRUE,
  normalize = TRUE,
  ...
)

set_parameters(
  model,
  parameters = NULL,
  param_type = NULL,
  warning = FALSE,
  ...
)

get_parameters(model, param_type = NULL)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{parameters}{A vector of real numbers in [0,1]. Values of parameters to
specify (optional). By default, parameters is drawn from the parameters dataframe.
See \code{inspect(model, "parameters_df")}.}

\item{param_type}{A character. String specifying type of parameters to make
"flat", "prior_mean", "posterior_mean", "prior_draw",
"posterior_draw", "define". With param_type set to \code{define} use
arguments to be passed to \code{make_priors}; otherwise \code{flat} sets
equal probabilities on each nodal type in each parameter set;
\code{prior_mean}, \code{prior_draw}, \code{posterior_mean},
\code{posterior_draw} take parameters as the means or as draws
from the prior or posterior.}

\item{warning}{Logical. Whether to warn about parameter renormalization.}

\item{normalize}{Logical. If parameter given for a subset of a family the
residual elements are normalized so that parameters in param_set sum
to 1 and provided params are unaltered.}

\item{...}{Options passed onto \code{\link{make_priors}}.}
}
\value{
A vector of draws from the prior or distribution of parameters

An object of class \code{causal_model}. It essentially returns a
  list containing the elements comprising a model
  (e.g. 'statement', 'nodal_types' and 'DAG') with true vector of
  parameters attached to it.

A vector of draws from the prior or distribution of parameters
}
\description{
Functionality for altering parameters:

A vector of 'true' parameters; possibly drawn from prior or posterior.

Add a true parameter vector to a model. Parameters can be created using
arguments passed to \code{\link{make_parameters}} and
\code{\link{make_priors}}.

Extracts parameters as a named vector
}
\examples{

# make_parameters examples:

# Simple examples
model <- make_model('X -> Y')
data  <- make_data(model, n = 2)
model <- update_model(model, data)
make_parameters(model, parameters = c(.25, .75, 1.25,.25, .25, .25))
make_parameters(model, param_type = 'flat')
make_parameters(model, param_type = 'prior_draw')
make_parameters(model, param_type = 'prior_mean')
make_parameters(model, param_type = 'posterior_draw')
make_parameters(model, param_type = 'posterior_mean')


\donttest{

#altering values using \code{alter_at}
make_model("X -> Y") |> make_parameters(parameters = c(0.5,0.25),
alter_at = "node == 'Y' & nodal_type \%in\% c('00','01')")

#altering values using \code{param_names}
make_model("X -> Y") |> make_parameters(parameters = c(0.5,0.25),
param_names = c("Y.10","Y.01"))

#altering values using \code{statement}
make_model("X -> Y") |> make_parameters(parameters = c(0.5),
statement = "Y[X=1] > Y[X=0]")

#altering values using a combination of other arguments
make_model("X -> Y") |> make_parameters(parameters = c(0.5,0.25),
node = "Y", nodal_type = c("00","01"))

# Normalize renormalizes values not set so that value set is not renomalized
make_parameters(make_model('X -> Y'),
               statement = 'Y[X=1]>Y[X=0]', parameters = .5)
make_parameters(make_model('X -> Y'),
               statement = 'Y[X=1]>Y[X=0]', parameters = .5,
               normalize = FALSE)

  }

# set_parameters examples:

make_model('X->Y') |>  set_parameters(1:6) |>  inspect("parameters")

# Simple examples
model <- make_model('X -> Y')
data  <- make_data(model, n = 2)
model <- update_model(model, data)
set_parameters(model, parameters = c(.25, .75, 1.25,.25, .25, .25))
set_parameters(model, param_type = 'flat')
set_parameters(model, param_type = 'prior_draw')
set_parameters(model, param_type = 'prior_mean')
set_parameters(model, param_type = 'posterior_draw')
set_parameters(model, param_type = 'posterior_mean')


\donttest{

#altering values using \code{alter_at}
make_model("X -> Y") |> set_parameters(parameters = c(0.5,0.25),
alter_at = "node == 'Y' & nodal_type \%in\% c('00','01')")

#altering values using \code{param_names}
make_model("X -> Y") |> set_parameters(parameters = c(0.5,0.25),
param_names = c("Y.10","Y.01"))

#altering values using \code{statement}
make_model("X -> Y") |> set_parameters(parameters = c(0.5),
statement = "Y[X=1] > Y[X=0]")

#altering values using a combination of other arguments
make_model("X -> Y") |> set_parameters(parameters = c(0.5,0.25),
node = "Y", nodal_type = c("00","01"))


  }
}
\concept{parameters}
