% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomEffect.R
\name{randomEffect}
\alias{randomEffect}
\title{Sets or updates the covariance matrix of random effects}
\usage{
randomEffect(
  .Object,
  effect,
  value = NULL,
  isDiagonal = TRUE,
  isFrozen = FALSE,
  ...
)
}
\arguments{
\item{.Object}{Model object}

\item{effect}{One or more names of available random effects.}

\item{value}{Initial values for the diagonal elements of the covariance matrix of
random effects (if \code{isDiagonal = TRUE}, or initial values for the lower triangular
elements (including diagonal elements) of the
covariance matrix (if \code{isDiagonal = FALSE}) in a row-wise order.}

\item{isDiagonal}{Set to \code{TRUE} to if the covariance matrix of the specified random effects is a diagonal matrix.
or \code{FALSE} if not.}

\item{isFrozen}{Set to \code{TRUE} to freeze the covariance matrix of random effects.}

\item{...}{Additional arguments}
}
\value{
Modified \code{NlmePmlModel} object
}
\description{
Use to set or update the covariance matrix of random effects in a model object.
}
\examples{
model <- pkmodel(
  numCompartments = 2,
  data = pkData,
  ID = "Subject",
  Time = "Act_Time",
  A1 = "Amount",
  CObs = "Conc",
  modelName = "TwCpt_IVBolus_FOCE_ELS",
  workingDir = tempdir()
  )

model <-
  randomEffect(model,
               effect = c("nV", "nCl", "nCl2"), value = rep(0.1, 3))
}
