% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PIC.R
\name{PaidIncurredChain}
\alias{PaidIncurredChain}
\title{PaidIncurredChain}
\usage{
PaidIncurredChain(triangleP, triangleI)
}
\arguments{
\item{triangleP}{Cumulative claims payments triangle}

\item{triangleI}{Incurred losses triangle.}
}
\value{
The function returns:
\itemize{
  \item \strong{Ult.Loss.Origin} Ultimate losses for different origin years.
  \item \strong{Ult.Loss} Total ultimate loss.
  \item \strong{Res.Origin} Claims reserves for different origin years.
  \item \strong{Res.Tot} Total reserve.
  \item \strong{s.e.} Square root of mean square error of prediction
  for the total ultimate loss.
}
}
\description{
The Paid-incurred Chain model (Merz, Wuthrich (2010)) combines
claims payments and incurred losses information to get
a unified ultimate loss prediction.
}
\details{
The method uses some basic properties of multivariate Gaussian distributions
to obtain a mathematically rigorous and consistent model for the combination
of the two information channels.

We assume as usual that I=J.
The model assumptions for the Log-Normal PIC Model are the following:
\itemize{
  \item Conditionally, given \eqn{latex}{\Theta = (\Phi_0,...,\Phi_I,
  \Psi_0,...,\Psi_{I-1},\sigma_0,...,\sigma_{I-1},\tau_0,...,\tau_{I-1})}
  we have
  \itemize{
    \item the random vector \eqn{latex}{(\xi_{0,0},...,\xi_{I,I},
    \zeta_{0,0},...,\zeta_{I,I-1})} has multivariate Gaussian distribution
    with uncorrelated components given by
    \deqn{latex}{\xi_{i,j} \sim N(\Phi_j,\sigma^2_j),}
    \deqn{latex}{\zeta_{k,l} \sim N(\Psi_l,\tau^2_l);}
    \item cumulative payments are given by the recursion
    \deqn{latex}{P_{i,j} = P_{i,j-1} \exp(\xi_{i,j}),}
    with initial value \eqn{P_{i,0} = \exp (\xi_{i,0})};
    \item incurred losses \eqn{I_{i,j}} are given by the backwards
    recursion
    \deqn{latex}{I_{i,j-1} = I_{i,j} \exp(-\zeta_{i,j-1}),}
    with initial value \eqn{I_{i,I}=P_{i,I}}.
  }
  \item The components of \eqn{latex}{\Theta} are indipendent and
  \eqn{latex}{\sigma_j,\tau_j > 0} for all j.
 }


Parameters \eqn{latex}{\Theta} in the model are in general not known and need to be
estimated from observations. They are estimated in a Bayesian framework.
In the Bayesian PIC model they assume that the previous assumptions
hold true with deterministic \eqn{latex}{\sigma_0,...,\sigma_J} and
\eqn{latex}{\tau_0,...,\tau_{J-1}} and
\deqn{latex}{\Phi_m \sim N(\phi_m,s^2_m),}
\deqn{latex}{\Psi_n \sim N(\psi_n,t^2_n).}
This is not a full Bayesian approach but has the advantage to give
analytical expressions for the posterior distributions and the prediction
uncertainty.
}
\note{
The model is implemented in the special case of non-informative priors.
}
\examples{
PaidIncurredChain(USAApaid, USAAincurred)
}
\author{
Fabio Concina, \email{fabio.concina@gmail.com}
}
\references{
Merz, M., Wuthrich, M. (2010). Paid-incurred chain claims reserving method.
Insurance: Mathematics and Economics, 46(3), 568-579.
}
\seealso{
\code{\link{MackChainLadder}},\code{\link{MunichChainLadder}}
}

