% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfN_GeneralizedPoisson.R
\name{cfN_GeneralizedPoisson}
\alias{cfN_GeneralizedPoisson}
\title{Characteristic function of Generalized Poisson distribution}
\usage{
cfN_GeneralizedPoisson(t, a, p = 0.5, cfX)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{a}{variable mean, a > 0}

\item{p}{success probability, \eqn{0 \le p \le 1}, default value p = 1/2}

\item{cfX}{function}
}
\value{
characteristic function cf(t) of the Poisson distribution with rate lambda
}
\description{
cfN_GeneralizedPoisson(t, a, p) evaluates the characteristic function cf(t) of the
Generalized Poisson with the parameter a (variable mean, a > 0),
and p (success probability, \eqn{0 \le p \le 1}) i.e.
cfN_GeneralizedPoisson(t, a, p) = exp(a*(sum_{j=1}^Inf ((p*j)^(j-1)*e^(-p*j)/j!)*e^(1i*t*j)-1))

The Generalized-Poisson distribution is equivalent
with the Borel-Tanner distribution with parameters (p,m)

cfN_GeneralizedPoisson(t, a, p, cfX) evaluates the compound characteristic function
cf(t) = cfN_GeneralizedPoisson(-1i*log(cfX(t)), a, p), where cfX is function
handle of the characteristic function cfX(t) of a continuous distribution
and/or random variable X.

Note that such CF is characteristic function of the compound distribution,
i.e. distribution of the random variable Y = X_1 + ... + X_N, where X_i ~ F_X
are i.i.d. random variables with common CF cfX(t), and N ~ F_N is
independent RV with its CF given by cfN(t).
}
\examples{
## EXAMPLE1 (CF of the Generalized-Poisson distribution with a = 10, p = 0.5)
a <- 10
p <- 0.5
t <- seq(-10, 10, length.out = 501)
plotGraf(function(t)
  cfN_GeneralizedPoisson(t, a, p), t,
  title = "CF of the Generalized-Poisson distribution with a = 10, p = 0.5")

## EXAMPLE2 (CF of the compound Generalized-Poisson-Exponential distribution)
a <- 10
p <- 0.5
lambda <- 5
cfX <- function(t)
  cfX_Exponential(t, lambda)
t <- seq(-10, 10, length.out = 501)
plotGraf(function(t)
  cfN_GeneralizedPoisson(t, a, p, cfX), t,
  title = "CF of the compound Generalized-Poisson-Exponential distribution")

## EXAMPLE3 (PDF/CDF of the compound Generalized-Poisson-Exponential distribution)
a <- 10
p <- 0.5
lambda <- 5
cfX <- function(t)
  cfX_Exponential(t, lambda)
cf <- function(t)
  cfN_GeneralizedPoisson(t, a, p, cfX)
x <- seq(0, 15, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
result <- cf2DistGP(cf, x, prob, isCompound = TRUE)
}
\seealso{
For more details

Other Discrete Probability Distribution: \code{\link{cfN_Binomial}},
  \code{\link{cfN_Delaporte}}, \code{\link{cfN_Geometric}},
  \code{\link{cfN_Logarithmic}},
  \code{\link{cfN_NegativeBinomial}},
  \code{\link{cfN_Poisson}},
  \code{\link{cfN_PolyaEggenberger}}
}

