% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcaSpectra.R
\name{hcaSpectra}
\alias{hcaSpectra}
\title{Plot HCA Results of a Spectra Object}
\usage{
hcaSpectra(spectra, c.method = "complete", d.method = "euclidean",
  use.sym = FALSE, leg.loc = "topright", ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}}.}

\item{c.method}{A character string describing the clustering method; must be
acceptable to \code{\link{hclust}}.}

\item{d.method}{A character string describing the distance calculation
method; must be acceptable as a method in \code{\link{rowDist}}.}

\item{use.sym}{A logical; if true, use no color and use lower-case letters
to indicate group membership.}

\item{leg.loc}{Character; if \code{"none"} no legend will be drawn.
Otherwise, any string acceptable to \code{\link{legend}}.}

\item{\dots}{Other parameters to be passed to the plotting functions.}
}
\value{
A list, containing an object of class \code{\link{hclust}} and an
object of class \code{\link{dendrogram}}.  The side effect is a plot.
}
\description{
A wrapper which carries out HCA and plots a dendrogram colored by the
information in a \code{\link{Spectra}} object.  Many methods for computing
the clusters and distances are available.
}
\examples{

data(SrE.IR)
myt <- expression(bolditalic(Serenoa)~bolditalic(repens)~bold(IR~Spectra))
res <- hcaSpectra(SrE.IR, main = myt)

}
\references{
\url{https://github.com/bryanhanson/ChemoSpec}
}
\seealso{
\code{\link{hclust}} for the underlying function.
\code{\link{hcaScores}} for similar analysis of PCA scores from a
\code{\link{Spectra}} object. \code{\link{plotHCA}} for the function that
actually does the plotting.
}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{cluster}
\keyword{multivariate}
