% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DolloSCM.R
\name{DolloSCM}
\alias{DolloSCM}
\title{Stochastic Character Map For Dollo Character}
\usage{
DolloSCM(tree, tip.states)
}
\arguments{
\item{tree}{A tree in phylo format with barnch lengths and a value for \code{$root.time}.}

\item{tip.states}{A vector of tip states (must be 0 or 1) with names matching \code{tree$tip.label}.}
}
\value{
\item{Changes}{A matrix of all changes (gains and losses).}
\item{SCM}{The stochastic character map.}
}
\description{
Given a tree with binary tip states produces a stochastic Dollo character map.
}
\details{
A non-ideal solution to the problem of generating a stochastic character map for a Dollo character (i.e., a single gain of the derived state (1) with any number of losses).

The function operates as follows:

1) Establishes least inclusive clade exhibiting the derived state (1).
2) Assumes single gain occurred on branch subtending this clade and with equal probability of occurring at any point along the branch.
3) Treats inclusive clade as a subtree and places a strong prior on the root of the derived state (1).
4) Calls \code{make.simmap} from the \code{phytools} package to generate a stochastic character map using a model where only losses are possible.
5) Outputs both the stochastic character map (time spent in each state on each branch) and a matrix of state changes.

(NB: As the map is stochastic the answer will be different each time the function is run and multiple replicates are strongly advised in order to ascertain uncertainty.)

This was the method used in Tarver et al. (2018).
}
\examples{

# Create a random 10-taxon tree:
tree <- rtree(10)

# Arbitrarily add a root.time value of 100 Ma:
tree$root.time <- 100

# Generate random tip states (0s and 1s):
tip.states <- sample(c(0, 1), 10, replace = TRUE)

# Add labels to tip states:
names(tip.states) <- tree$tip.label

# Get a single stochastic character map:
out <- DolloSCM(tree, tip.states)

# View matrix of changes:
out$Changes

# View stochastic character map (time spent in each state on each branch):
out$SCM

}
\references{
Tarver, J. E., Taylor, R. S., Puttick, M. N., Lloyd, G. T., Pett, W., Fromm, B., Schirrmeister, B. E., Pisani, D., Peterson, K. J. and Donoghue, P. C. J., 2018. Well-annotated microRNAomes do not evidence pervasive miRNA loss. Genome Biology and Evolution, 6, 1457-1470.
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
