% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatrixPruner.R
\name{MatrixPruner}
\alias{MatrixPruner}
\title{Prunes a character matrix of characters or taxa}
\usage{
MatrixPruner(CladisticMatrix, blocks2prune = c(),
  characters2prune = c(), taxa2prune = c(), removeinvariant = FALSE)
}
\arguments{
\item{CladisticMatrix}{The cladistic matrix in the format imported by \link{ReadMorphNexus}.}

\item{blocks2prune}{A vector of number(s) of any blocks to prune.}

\item{characters2prune}{A vector of character numbers to prune.}

\item{taxa2prune}{A vector of taxon names to prune (these must be present in \code{rownames(CladisticMatrix$matrix}).}

\item{removeinvariant}{A logical for whether invariant characters should (TRUE) or should not (FALSE, default) be pruned.}
}
\description{
Prunes a character matrix of characters, taxa, or both.
}
\details{
Removing characters or taxa from a matrix imported using \link{ReadMorphNexus} is not simple due to associated vectors for ordering, character weights etc. To save repetitively pruning each part this function takes the matrix as input and vector(s) of either block numbers, character numbers, taxon names, or any combination thereof and returns a matrix with these items removed. Minimum and maximum values (used by \link{MorphDistMatrix}) are also updated and the user has the option to remove constant characters this way as well (e.g, to reduce the memory required for a DNA matrix).
}
\examples{

# Remove the outgroup taxon and characters 11 and 53 from Gauthier1986:
prunedmatrix <- MatrixPruner(CladisticMatrix = Gauthier1986, characters2prune = c(11, 53),
  taxa2prune = c("Outgroup"))

# Show priuned matrix:
prunedmatrix$Matrix_1$Matrix

}
\seealso{
\link{ReadMorphNexus}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
\keyword{NEXUS}
