% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{eai}
\alias{eai}
\title{Emberger aridity index}
\usage{
eai(pr, taverage, data_names = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{pr}{precipitation}

\item{taverage}{medium temperature}

\item{data_names}{names of each period of time}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}

\item{...}{...}
}
\value{
Emberger Aridity Index
}
\description{
Aridity index based on annual precipitation and temperature range
}
\section{Formula}{
 \deqn{EAI = \frac {100*P}{Thm^2 - Tcm^2}} P = annual precipitation; Thm = Average temperature of the hottest month in Kelvin; Tcm= Average temperature of the coldest month in Kelvin
}

\examples{
data(data_all)
eai(pr = data_all$rr, taverage = data_all$tg)
}
\references{
Emberger L. 1930. La végétation de la région méditerranéenne: essai d'une classification des groupements végétaux Revue Générale de Botanique, 42 (641–662), pp. 705-721
}
