% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProjectProgress.R
\name{getProjectProgress}
\alias{getProjectProgress}
\title{Get project progress}
\usage{
getProjectProgress(key, project, server = "climmob3", ...)
}
\arguments{
\item{key}{a character for the user's application programming 
interface (API) key}

\item{project}{a character with the id of one or more projects}

\item{server}{optional, a character to select from which server
the data will be retrieved. See details}

\item{...}{additional arguments passed to methods. See details}
}
\value{
A data frame with the ClimMob projects 
\item{project_id}{the project unique id}
\item{name}{the project name}
\item{moment}{either the design, registration or data collection}
\item{number_obs}{number of observations collected in a given moment}
\item{last_activity}{last activity of the given moment}
}
\description{
Fetch the progress of a ClimMob project
}
\details{
\code{server}: the default server is "climmob" used for clients of 
https://climmob.net/climmob3/, other options are:

 "avisa" for clients of https://avisa.climmob.net/ 
 
 "rtb" for clients of https://rtb.climmob.net/
 
 "testing" for clients of https://testing.climmob.net/climmob3/
}
\examples{
\dontrun{ 
# This function will not work without an API key  
# the user API key can be obtained once a free ClimMob account 
# is created via https://climmob.net/

my_key <- "add_your_key"

my_project <- "project_id"

getProjectProgress(my_key, my_project)

}

}
\seealso{
ClimMob website \url{https://climmob.net/}

Other GET functions: 
\code{\link{getDataCM}()},
\code{\link{getProjectsCM}()}
}
\author{
Kauê de Sousa
}
\concept{GET functions}
