#' @export print.hclustgeo
#' @name print.hclustgeo
#' @method print hclustgeo
#' @S3method print hclustgeo
#' @title Print a 'hclustgeo' object
#' @description This is a method for the function print for objects of the class \code{hclustgeo}.
#' @param x an object of class  \code{hclustgeo} generated by the function \code{hclustgeo}
#' @param \dots  further arguments to be passed to or from other methods. They are ignored in this function.


print.hclustgeo <- function(x, ...){
  if (!inherits(x, "hclustgeo")) 
    stop("use only with \"hclustgeo\" objects")
  
  cat("Method = hclustgeo")
  cat("\n")
  cat("\n")
  
  cat("Each result of hclustgeo corresponding to a value of alpha is conserved in a different object")
  cat("\n")
  cat("The list of available results is given below:")
  cat("\n")
  cat("\n")
  cat(paste("$results.hclustgeo","$'",names(x[[1]]),"'",sep=""),sep="\n")
 
}