% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{[.clustering}
\alias{[.clustering}
\title{Filter metrics in a \code{clustering} object returning a new
\code{clustering} object.}
\usage{
\method{[}{clustering}(clustering, condition = TRUE)
}
\arguments{
\item{clustering}{The \code{clustering} object to filter.}

\item{condition}{Expression to filter the \code{clustering} object.}
}
\value{
A \code{clustering} object filtered from the input parameters.
}
\description{
Generates a new filtered \code{clustering} object.
}
\details{
This function allows you to filter the data set for a given
evaluation metric. The evaluation metrics available are:
\code{Algorithm, Distance, Clusters, Data, Var, Time, Entropy,
Variation_information, Precision, Recall, F_measure, Fowlkes_mallows_index,
Connectivity, Dunn, Silhouette and TimeAtt}.
}
\examples{

library(Clustering)

result <- clustering(df = Clustering::basketball, algorithm = 'clara',
min=3, max=4, metrics = c('Precision','Recall'))

result[Precision > 0.14 & Recall > 0.11]

}
